/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Rule;
import java.util.ArrayList;
import java.util.List;

public class Pipeline {
    private final ArrayList<Rule> fRules = new ArrayList();

    public Pipeline() {
        this(new ArrayList<Rule>());
    }

    public Pipeline(List<Rule> rules) {
        this.fRules.addAll(rules);
    }

    public Pipeline addRule(Rule r) {
        this.fRules.add(r);
        return this;
    }

    public void process(MessageProcessingContext context) {
        for (Rule r : this.fRules) {
            Filter f = r.getFilter();
            List<Processor> procs = f == null || f.passes(context) ? r.getThenProcs() : r.getElseProcs();
            for (Processor p : procs) {
                p.process(context);
                if (context.shouldContinue()) continue;
                break;
            }
            if (context.shouldContinue()) continue;
            break;
        }
    }
}

