/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sinks;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Sink;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FanOutSink
implements Sink {
    private final ArrayList<Sink> fSinks = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(FanOutSink.class);

    public FanOutSink(final ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        try {
            JsonVisitor.forEachElement((JSONArray)config.optJSONArray("sinks"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

                public boolean visit(JSONObject sink) throws JSONException, Builder.BuildFailure {
                    FanOutSink.this.fSinks.add(Builder.withBaseClass(Sink.class).providingContext((Object)sc).withClassNameInData().usingData(sink).build());
                    return true;
                }
            });
        }
        catch (JSONException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
    }

    @Override
    public void init() {
        for (Sink s : this.fSinks) {
            s.init();
        }
    }

    @Override
    public void close() {
        for (Sink s : this.fSinks) {
            try {
                s.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    @Override
    public void flush() {
        for (Sink s : this.fSinks) {
            s.flush();
        }
    }

    @Override
    public void process(Message msg) {
    }

    @Override
    public void process(MessageProcessingContext context) {
        for (Sink s : this.fSinks) {
            s.process(context);
        }
    }
}

