/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.filters;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.util.data.json.JsonVisitor;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneOf
implements Filter {
    private final String fKey;
    private final TreeSet<String> fValues;

    public OneOf(String key, String[] vals) {
        this.fKey = key;
        this.fValues = new TreeSet();
        for (String val : vals) {
            this.fValues.add(val);
        }
    }

    public OneOf(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public OneOf(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fKey = config.getString("key");
        this.fValues = new TreeSet();
        JsonVisitor.forEachElement((JSONArray)config.getJSONArray("values"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<Object, JSONException>(){

            public boolean visit(Object val) throws JSONException {
                OneOf.this.fValues.add(val.toString());
                return true;
            }
        });
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("class", (Object)this.getClass().getName()).put("key", (Object)this.fKey).put("values", (Object)JsonVisitor.collectionToArray(this.fValues));
        return result;
    }

    @Override
    public boolean passes(MessageProcessingContext ctx) {
        String val = ctx.getMessage().getValueAsString(this.fKey);
        return val != null && this.fValues.contains(val);
    }
}

