/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.config.readers;

import io.continual.builder.Builder;
import io.continual.resources.ResourceLoader;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.config.readers.ConfigReadException;
import io.continual.services.processor.config.readers.ConfigReader;
import io.continual.services.processor.engine.library.filters.Any;
import io.continual.services.processor.engine.library.processors.Set;
import io.continual.services.processor.engine.library.sinks.NullSink;
import io.continual.services.processor.engine.library.sources.NullSource;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.Pipeline;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Program;
import io.continual.services.processor.engine.model.Rule;
import io.continual.services.processor.engine.model.Sink;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.service.ProcessingService;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonConfigReader
implements ConfigReader {
    private static final Logger log = LoggerFactory.getLogger(JsonConfigReader.class);

    @Override
    public Program read(String resName) throws ConfigReadException {
        try {
            return this.read(ResourceLoader.load((String)resName));
        }
        catch (IOException e) {
            throw new ConfigReadException(e);
        }
    }

    @Override
    public Program read(InputStream is) throws ConfigReadException {
        if (is == null) {
            throw new ConfigReadException("Can't read a null stream.");
        }
        return this.read(JsonUtil.readJsonObject((InputStream)is));
    }

    public Program read(JSONObject obj) throws ConfigReadException {
        return this.read(new ServiceContainer(), obj);
    }

    public Program read(final ServiceContainer sc, JSONObject obj) throws ConfigReadException {
        if (obj == null) {
            throw new ConfigReadException("Can't read a null object.");
        }
        final Program p = new Program();
        log.info("Loading program...");
        final ArrayList<String> pkgs = new ArrayList<String>();
        pkgs.add("io.continual.services.processor.engine.library.filters");
        pkgs.add("io.continual.services.processor.engine.library.processors");
        pkgs.add("io.continual.services.processor.engine.library.sinks");
        pkgs.add("io.continual.services.processor.engine.library.sources");
        JsonVisitor.forEachElement((JSONArray)obj.optJSONArray("packages"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, ConfigReadException>(){

            public boolean visit(String pkgName) throws ConfigReadException {
                pkgs.add(pkgName + ".services");
                pkgs.add(pkgName + ".filters");
                pkgs.add(pkgName + ".processors");
                pkgs.add(pkgName + ".sources");
                pkgs.add(pkgName + ".sinks");
                log.info("\twith package {}...", (Object)pkgName);
                return true;
            }
        });
        JsonVisitor.forEachElement((JSONObject)obj.optJSONObject("sinks"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, ConfigReadException>(){

            public boolean visit(String sinkName, JSONObject sink) throws ConfigReadException {
                try {
                    p.addSink(sinkName, (Sink)Builder.withBaseClass(Sink.class).withClassNameInData().searchingPath(NullSink.class.getPackage().getName()).searchingPaths((Collection)pkgs).providingContext((Object)sc).usingData(sink).build());
                    log.info("\twith sink {}...", (Object)sinkName);
                }
                catch (Builder.BuildFailure | JSONException e) {
                    throw new ConfigReadException(e);
                }
                return true;
            }
        });
        JsonVisitor.forEachElement((JSONObject)obj.optJSONObject("pipelines"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONArray, ConfigReadException>(){

            public boolean visit(String pipelineName, JSONArray rules) throws ConfigReadException {
                Pipeline pl = JsonConfigReader.this.readPipeline(pipelineName, rules, pkgs, sc);
                p.addPipeline(pipelineName, pl);
                log.info("\twith pipeline {}...", (Object)pipelineName);
                return true;
            }
        });
        JsonVisitor.forEachElement((JSONObject)obj.optJSONObject("sources"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, ConfigReadException>(){

            public boolean visit(String srcName, JSONObject source) throws ConfigReadException {
                try {
                    source.put("name", (Object)srcName);
                    JsonConfigReader.this.readSource(sc, p, pkgs, srcName, source);
                }
                catch (Builder.BuildFailure | JSONException e) {
                    throw new ConfigReadException(e);
                }
                return true;
            }
        });
        return p;
    }

    public Pipeline readPipeline(String pipelineName, JSONArray rules, final ArrayList<String> pkgs, final ServiceContainer sc) throws ConfigReadException {
        try {
            final Pipeline pl = new Pipeline();
            JsonVisitor.forEachElement((JSONArray)rules, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, ConfigReadException>(){

                public boolean visit(JSONObject rule) throws ConfigReadException {
                    try {
                        Filter f;
                        boolean isAlways = false;
                        JSONObject ifBlock = rule.optJSONObject("if");
                        if (ifBlock != null) {
                            f = (Filter)Builder.withBaseClass(Filter.class).withClassNameInData().searchingPath(Any.class.getPackage().getName()).searchingPaths((Collection)pkgs).providingContext((Object)sc).usingData(rule.getJSONObject("if")).build();
                        } else {
                            isAlways = true;
                            f = new Any();
                        }
                        List thenSteps = JsonConfigReader.this.readProcessorArray(sc, pkgs, rule.optJSONArray(isAlways ? "always" : "then"));
                        ArrayList elseSteps = isAlways ? new ArrayList() : JsonConfigReader.this.readProcessorArray(sc, pkgs, rule.optJSONArray("else"));
                        pl.addRule(new Rule.Builder().checkIf(f).thenDo(thenSteps).elseDo(elseSteps).build());
                    }
                    catch (Builder.BuildFailure | JSONException e) {
                        throw new ConfigReadException(e);
                    }
                    return true;
                }
            });
            return pl;
        }
        catch (JSONException e) {
            throw new ConfigReadException(e);
        }
    }

    private Source readSource(final ServiceContainer sc, final Program p, final List<String> pkgs, final String srcName, JSONObject source) throws Builder.BuildFailure {
        Source src = (Source)Builder.withBaseClass(Source.class).withClassNameInData().searchingPath(NullSource.class.getPackage().getName()).searchingPaths(pkgs).providingContext((Object)sc).usingData(source).build();
        p.addSource(srcName, src);
        log.info("\twith source {}...", (Object)srcName);
        JsonVisitor.forEachElement((JSONObject)source.optJSONObject("services"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<JSONObject, Builder.BuildFailure>(){

            public boolean visit(String serviceName, JSONObject svcBlock) throws JSONException, Builder.BuildFailure {
                ProcessingService ps = (ProcessingService)Builder.withBaseClass(ProcessingService.class).withClassNameInData().searchingPaths((Collection)pkgs).providingContext((Object)sc).usingData(svcBlock).build();
                p.addServiceToSource(srcName, serviceName, ps);
                log.info("\t\twith service {}...", (Object)serviceName);
                return true;
            }
        });
        return src;
    }

    private List<Processor> readProcessorArray(final ServiceContainer sc, final List<String> pkgs, JSONArray block) throws ConfigReadException {
        final ArrayList<Processor> result = new ArrayList<Processor>();
        JsonVisitor.forEachElement((JSONArray)block, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, ConfigReadException>(){

            public boolean visit(JSONObject thenStep) throws ConfigReadException {
                try {
                    result.add(Builder.withBaseClass(Processor.class).withClassNameInData().searchingPath(Set.class.getPackage().getName()).searchingPaths((Collection)pkgs).providingContext((Object)sc).usingData(thenStep).build());
                }
                catch (Builder.BuildFailure | JSONException e) {
                    throw new ConfigReadException(e);
                }
                return true;
            }
        });
        return result;
    }
}

