/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.metricTypes.Timer;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.engine.model.Rule;
import java.util.ArrayList;
import java.util.List;

public class Pipeline {
    private final ArrayList<Rule> fRules = new ArrayList();

    public Pipeline() {
        this(new ArrayList<Rule>());
    }

    public Pipeline(List<Rule> rules) {
        this.fRules.addAll(rules);
    }

    public Pipeline addRule(Rule r) {
        this.fRules.add(r);
        return this;
    }

    public void process(MessageProcessingContext context) {
        MetricsCatalog mc = context.getMetrics();
        int ruleIndex = 0;
        for (Rule r : this.fRules) {
            MetricsCatalog.PathPopper pp = mc.push("rule-" + ruleIndex++);
            Throwable throwable = null;
            try {
                Timer.Context ruleDurCtx = mc.timer("total").time();
                Throwable throwable2 = null;
                try {
                    String procChainLabel;
                    List<Processor> procs;
                    Filter f = r.getFilter();
                    if (f == null || f.passes(context)) {
                        procs = r.getThenProcs();
                        procChainLabel = "filterPass";
                    } else {
                        procs = r.getElseProcs();
                        procChainLabel = "filterFail";
                    }
                    try (MetricsCatalog.PathPopper pp2 = mc.push(procChainLabel);){
                        int procIndex = 0;
                        for (Processor p : procs) {
                            String procName = Pipeline.makeMetricsName(p, procIndex++);
                            MetricsCatalog.PathPopper pp3 = mc.push(procName);
                            Throwable throwable3 = null;
                            try {
                                Timer.Context procDurCtx = mc.timer("totalTime").time();
                                Throwable throwable4 = null;
                                try {
                                    p.process(context);
                                    if (context.shouldContinue()) continue;
                                    break;
                                }
                                catch (Throwable throwable5) {
                                    throwable4 = throwable5;
                                    throw throwable5;
                                }
                                finally {
                                    if (procDurCtx == null) continue;
                                    if (throwable4 != null) {
                                        try {
                                            procDurCtx.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable4.addSuppressed(throwable6);
                                        }
                                        continue;
                                    }
                                    procDurCtx.close();
                                }
                            }
                            catch (Throwable throwable7) {
                                throwable3 = throwable7;
                                throw throwable7;
                            }
                            finally {
                                if (pp3 == null) continue;
                                if (throwable3 != null) {
                                    try {
                                        pp3.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable3.addSuppressed(throwable8);
                                    }
                                    continue;
                                }
                                pp3.close();
                            }
                        }
                    }
                    if (context.shouldContinue()) continue;
                    break;
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (ruleDurCtx == null) continue;
                    if (throwable2 != null) {
                        try {
                            ruleDurCtx.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    ruleDurCtx.close();
                }
            }
            catch (Throwable throwable11) {
                throwable = throwable11;
                throw throwable11;
            }
            finally {
                if (pp == null) continue;
                if (throwable != null) {
                    try {
                        pp.close();
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                    }
                    continue;
                }
                pp.close();
            }
        }
    }

    private static String makeMetricsName(Processor p, int i) {
        String clazz = p.getClass().getSimpleName();
        return "proc-" + i + " (" + clazz + ")";
    }
}

