/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sinks;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.Sink;
import io.continual.util.data.TypeConvertor;
import io.continual.util.data.csv.CsvLineBuilder;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonVisitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CsvSink
implements Sink {
    public static final String stdout = "stdout";
    public static final String stderr = "stderr";
    private final PrintStream fStream;
    private final boolean fCloseStream;
    private final ArrayList<ColInfo> fCols;
    private boolean fHasOutputHeader;

    public static CsvSink toStdOut() throws Builder.BuildFailure {
        return new CsvSink(stdout);
    }

    public CsvSink() throws Builder.BuildFailure {
        this(new JSONObject());
    }

    public CsvSink(String stream) throws Builder.BuildFailure {
        this(new JSONObject().put("to", (Object)stream));
    }

    public CsvSink(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public CsvSink(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        try {
            String to = config.optString("to", stdout);
            if (to.equals(stdout)) {
                this.fStream = System.out;
                this.fCloseStream = false;
            } else if (to.equals(stderr)) {
                this.fStream = System.err;
                this.fCloseStream = false;
            } else {
                this.fStream = new PrintStream(new FileOutputStream(new File(to)));
                this.fCloseStream = true;
            }
            this.fCols = new ArrayList();
            JsonVisitor.forEachObjectIn((JSONArray)config.optJSONArray("columns"), (JsonVisitor.ArrayOfObjectVisitor)new JsonVisitor.ArrayOfObjectVisitor(){

                public boolean visit(JSONObject col) throws JSONException {
                    CsvSink.this.fCols.add(new ColInfo(col));
                    return true;
                }
            });
            boolean wantHeader = config.optBoolean("outputHeader", true);
            this.fHasOutputHeader = !wantHeader;
        }
        catch (FileNotFoundException | JSONException e) {
            throw new Builder.BuildFailure(e);
        }
    }

    public CsvSink addColumn(String key, String value) {
        return this.addColumn(key, value, String.class);
    }

    public CsvSink addColumn(String key, String value, Class<?> clazz) {
        this.fCols.add(new ColInfo(key, value, clazz));
        return this;
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
        if (this.fCloseStream) {
            this.fStream.close();
        }
    }

    @Override
    public void flush() {
        this.fStream.flush();
    }

    @Override
    public void process(Message msg) {
        if (!this.fHasOutputHeader) {
            CsvLineBuilder clb = new CsvLineBuilder();
            for (ColInfo ci : this.fCols) {
                clb.append(ci.getKey());
            }
            this.fStream.println(clb.toString());
            this.fHasOutputHeader = true;
        }
        JSONObject msgJson = msg.toJson();
        CsvLineBuilder clb = new CsvLineBuilder();
        for (ColInfo ci : this.fCols) {
            String val = JsonEval.substitute((String)ci.getExpr(), (JSONObject)msgJson);
            Class<?> targetClass = ci.getTargetClass();
            try {
                if (targetClass.equals(Integer.class)) {
                    clb.append((long)Integer.parseInt(val));
                    continue;
                }
                if (targetClass.equals(Long.class)) {
                    clb.append(Long.parseLong(val));
                    continue;
                }
                if (targetClass.equals(Double.class)) {
                    clb.append(Double.parseDouble(val));
                    continue;
                }
                if (targetClass.equals(Boolean.class)) {
                    clb.append(TypeConvertor.convertToBooleanBroad((String)val));
                    continue;
                }
                clb.append(val);
            }
            catch (NumberFormatException e) {
                clb.append(val);
            }
        }
        this.fStream.println(clb.toString());
    }

    private static class ColInfo {
        private final String fKey;
        private final String fExpr;
        private final Class<?> fClass;

        public ColInfo(String key, String expr, Class<?> clazz) {
            this.fKey = key;
            this.fExpr = expr;
            this.fClass = clazz;
        }

        public ColInfo(JSONObject data) {
            this(data.getString("key"), data.getString("expr"), ColInfo.classFrom(data.optString("type", null)));
        }

        public String getKey() {
            return this.fKey;
        }

        public String getExpr() {
            return this.fExpr;
        }

        public Class<?> getTargetClass() {
            return this.fClass;
        }

        private static Class<?> classFrom(String text) {
            if (text == null || text.length() == 0) {
                return String.class;
            }
            if ((text = text.trim().toLowerCase()).startsWith("int")) {
                return Integer.class;
            }
            if (text.startsWith("long")) {
                return Long.class;
            }
            if (text.startsWith("double")) {
                return Double.class;
            }
            if (text.startsWith("bool")) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

