/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.builder.Builder;
import io.continual.resources.ResourceLoader;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.library.sources.BasicSource;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.data.json.JsonVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvSource
extends BasicSource {
    private final String fResource;
    private final String fFieldDelim;
    private final List<String> fFieldList;
    private final String fLineNumberToField;
    private final HashMap<String, String> fFieldMap;
    private boolean fInited = false;
    private InputStream fStream = null;
    private CSVParser fParser = null;
    private Iterator<CSVRecord> fIterator = null;
    private int fLineNumber;
    private static final Logger log = LoggerFactory.getLogger(CsvSource.class);

    public CsvSource(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public CsvSource(String defPipeline, String resource) throws Builder.BuildFailure {
        super(defPipeline);
        try {
            this.fResource = resource;
            this.fFieldDelim = null;
            this.fFieldList = null;
            this.fLineNumberToField = null;
            this.fFieldMap = new HashMap();
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    public CsvSource(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(config);
        try {
            this.fResource = config.optString("data", "");
            this.fFieldDelim = config.optString("fieldDelimiter", null);
            this.fFieldList = JsonVisitor.arrayToList((JSONArray)config.optJSONArray("fields"));
            this.fLineNumberToField = config.optString("lineNumberTo", null);
            this.fFieldMap = new HashMap();
            JsonVisitor.forEachElement((JSONObject)config.optJSONObject("fieldMap"), (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<String, JSONException>(){

                public boolean visit(String srcField, String mappedField) throws JSONException {
                    CsvSource.this.fFieldMap.put(srcField, mappedField);
                    return true;
                }
            });
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.fParser != null) {
            this.fParser.close();
        }
        this.fParser = null;
        this.fInited = true;
        super.close();
    }

    public CsvSource setResource(InputStream data) {
        this.fStream = data;
        return this;
    }

    @Override
    public boolean isEof() {
        return this.fInited && this.fParser == null;
    }

    @Override
    protected MessageAndRouting internalGetNextMessage(StreamProcessingContext spc) throws IOException {
        this.init(spc);
        if (this.isEof()) {
            return null;
        }
        if (this.fIterator.hasNext()) {
            ++this.fLineNumber;
            return this.buildMessage(this.fIterator.next());
        }
        this.fParser.close();
        this.fParser = null;
        return null;
    }

    private void init(StreamProcessingContext spc) throws IOException {
        if (!this.fInited) {
            String name;
            this.fInited = true;
            if (this.fStream == null) {
                name = spc.evalExpression(this.fResource);
                if (name == null || name.length() == 0) {
                    throw new IOException("No resource name provided.");
                }
                this.fStream = ResourceLoader.load((String)name);
                log.info("loaded {}", (Object)name);
            }
            if (this.fStream == null) {
                name = spc.evalExpression(this.fResource);
                throw new IOException("Unable to load resource: " + name + " (" + this.fResource + ")");
            }
            CSVFormat format = CSVFormat.DEFAULT;
            if (this.fFieldDelim != null && this.fFieldDelim.equals("\t")) {
                format = CSVFormat.TDF;
            }
            format = this.fFieldList != null && this.fFieldList.size() > 0 ? format.withHeader(this.fFieldList.toArray(new String[this.fFieldList.size()])) : format.withFirstRecordAsHeader();
            this.fParser = new CSVParser((Reader)new InputStreamReader(this.fStream), format);
            this.fIterator = this.fParser.iterator();
            this.fLineNumber = 1;
        }
    }

    private MessageAndRouting buildMessage(CSVRecord record) {
        JSONObject data = new JSONObject();
        for (String key : this.fParser.getHeaderMap().keySet()) {
            String newKey = this.fFieldMap.get(key);
            data.put(newKey != null ? newKey : key, (Object)record.get(key));
        }
        if (this.fLineNumberToField != null) {
            data.put(this.fLineNumberToField, this.fLineNumber);
        }
        return this.makeDefRoutingMessage(new Message(data));
    }
}

