/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.filters;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.time.Clock;
import org.json.JSONObject;

public class TimeFilter
implements Filter {
    private final String fExpr;
    private final Boundary fMin;
    private final Boundary fMax;

    public TimeFilter(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this.fExpr = config.getString("expr");
        this.fMin = TimeFilter.readBoundary(config, "lowerLimit");
        this.fMax = TimeFilter.readBoundary(config, "upperLimit");
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("class", (Object)this.getClass().getName()).put("expr", (Object)this.fExpr).put("lowerLimit", (Object)this.fMin.toJson()).put("upperLimit", (Object)this.fMax.toJson());
        return result;
    }

    @Override
    public boolean passes(MessageProcessingContext ctx) {
        Long timeValObj = ctx.evalExpression(this.fExpr, Long.class);
        long timeVal = timeValObj == null ? 0L : timeValObj;
        return !(this.fMin != null && !this.fMin.isLessThan(timeVal) || this.fMax != null && !this.fMax.isGreaterThan(timeVal));
    }

    private static Boundary readBoundary(JSONObject config, String label) throws Builder.BuildFailure {
        String spec = config.optString(label, null);
        if (spec == null) {
            return null;
        }
        return new Boundary(spec);
    }

    private static long readDiff(String diff) throws Builder.BuildFailure {
        int len = diff.length();
        if (len < 1) {
            throw new Builder.BuildFailure("Empty time difference value.");
        }
        char lastChar = diff.charAt(len - 1);
        String allButLast = diff.substring(0, len - 1);
        switch (lastChar) {
            case 'h': {
                return Long.parseLong(allButLast) * 3600000L;
            }
            case 'm': {
                return Long.parseLong(allButLast) * 60000L;
            }
            case 's': {
                return Long.parseLong(allButLast) * 1000L;
            }
        }
        return Long.parseLong(diff);
    }

    private static class Boundary
    implements JsonSerialized {
        private final long fLimit;
        private final boolean fIsAbsolute;

        public Boundary(String spec) throws Builder.BuildFailure {
            try {
                spec = spec.trim();
                char first = spec.charAt(0);
                if (first == '+') {
                    this.fIsAbsolute = false;
                    this.fLimit = TimeFilter.readDiff(spec.substring(1));
                } else if (first == '-') {
                    this.fIsAbsolute = false;
                    this.fLimit = -1L * TimeFilter.readDiff(spec.substring(1));
                } else {
                    this.fIsAbsolute = true;
                    this.fLimit = Long.parseLong(spec);
                }
            }
            catch (NumberFormatException x) {
                throw new Builder.BuildFailure((Throwable)x);
            }
        }

        public JSONObject toJson() {
            return new JSONObject();
        }

        public boolean isGreaterThan(long timeValMs) {
            return timeValMs < this.getTime();
        }

        public boolean isGreaterOrEqual(long timeValMs) {
            return timeValMs <= this.getTime();
        }

        public boolean isLessThan(long timeValMs) {
            return timeValMs > this.getTime();
        }

        public boolean isLessThanOrEqual(long timeValMs) {
            return timeValMs >= this.getTime();
        }

        private long getTime() {
            return this.fIsAbsolute ? this.fLimit : Clock.now() + this.fLimit;
        }
    }
}

