/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.sources;

import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageAndRouting;
import io.continual.services.processor.engine.model.Source;
import io.continual.services.processor.engine.model.StreamProcessingContext;
import io.continual.util.time.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicSource
implements Source {
    private final String fDefPipeline;
    private final ArrayList<MessageAndRouting> fRequeued;
    private boolean fEof = false;
    private static final Logger log = LoggerFactory.getLogger(BasicSource.class);

    @Override
    public boolean isEof() {
        return this.fRequeued.size() == 0 && this.fEof;
    }

    @Override
    public void close() throws IOException {
        this.fEof = true;
    }

    @Override
    public synchronized void requeue(MessageAndRouting msgAndRoute) {
        this.fRequeued.add(msgAndRoute);
    }

    @Override
    public final synchronized MessageAndRouting getNextMessage(StreamProcessingContext spc, long timeUnit, TimeUnit units) throws IOException, InterruptedException {
        if (this.fRequeued.size() > 0) {
            return this.fRequeued.remove(0);
        }
        long endBy = Clock.now() + TimeUnit.MILLISECONDS.convert(timeUnit, units);
        long[] backoff = this.getBackoffTimes();
        int backoffIndex = 0;
        do {
            MessageAndRouting mr;
            if ((mr = this.internalGetNextMessage(spc, timeUnit, units)) != null) {
                return mr;
            }
            long backoffTimeMs = backoff[backoffIndex];
            log.debug("... backing off {} ms", (Object)backoffTimeMs);
            Thread.sleep(backoffTimeMs);
            backoffIndex = Math.min(backoffIndex + 1, backoff.length - 1);
        } while (Clock.now() < endBy);
        return null;
    }

    @Override
    public void markComplete(StreamProcessingContext spc, MessageAndRouting mr) {
    }

    protected abstract MessageAndRouting internalGetNextMessage(StreamProcessingContext var1, long var2, TimeUnit var4) throws IOException, InterruptedException;

    protected long[] getBackoffTimes() {
        return new long[]{1L, 1L, 2L, 3L, 5L, 8L, 13L, 21L, 34L, 55L, 89L, 144L, 233L, 377L, 610L, 987L};
    }

    protected BasicSource(String defaultPipelineName) {
        this.fDefPipeline = defaultPipelineName;
        this.fRequeued = new ArrayList();
    }

    protected BasicSource(JSONObject config) {
        this(config.getString("pipeline"));
    }

    protected BasicSource() {
        this((String)null);
    }

    protected MessageAndRouting makeDefRoutingMessage(Message msg) {
        return new MessageAndRouting(msg, this.fDefPipeline);
    }

    protected void noteEndOfStream() {
        this.fEof = true;
    }
}

