/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.processors;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.engine.model.Message;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Set
implements Processor {
    private final JSONObject fUpdates;
    private final boolean fAppendArray;
    private final boolean fEval;

    public Set(JSONObject updates) {
        this.fUpdates = JsonUtil.clone((JSONObject)updates);
        this.fAppendArray = true;
        this.fEval = true;
    }

    public Set(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fUpdates = JsonUtil.clone((JSONObject)config.optJSONObject("updates"));
        this.fAppendArray = config.optBoolean("appendArray", true);
        this.fEval = config.optBoolean("eval", true);
    }

    @Override
    public void process(final MessageProcessingContext context) {
        if (this.fUpdates == null) {
            context.warn("No updates provided to Set.");
            return;
        }
        final Message msg = context.getMessage();
        JsonVisitor.forEachElement((JSONObject)this.fUpdates, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String key, Object t) throws JSONException {
                Object data = Set.this.fEval ? Set.this.evaluate(context, t, msg) : t;
                JsonEval.setValue((JSONObject)msg.accessRawJson(), (String)key, (Object)data, (boolean)Set.this.fAppendArray);
                return true;
            }
        });
    }

    protected JSONObject evaluate(final MessageProcessingContext mpc, JSONObject value, final Message msg) {
        final JSONObject replacement = new JSONObject();
        JsonVisitor.forEachElement((JSONObject)value, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String key, Object val) throws JSONException {
                replacement.put(key, Set.this.evaluate(mpc, val, msg));
                return true;
            }
        });
        return replacement;
    }

    protected JSONArray evaluate(final MessageProcessingContext mpc, JSONArray value, final Message msg) {
        final JSONArray replacement = new JSONArray();
        JsonVisitor.forEachElement((JSONArray)value, (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<Object, JSONException>(){

            public boolean visit(Object val) throws JSONException {
                replacement.put(Set.this.evaluate(mpc, val, msg));
                return true;
            }
        });
        return replacement;
    }

    protected Object evaluate(MessageProcessingContext mpc, Object t, Message msg) {
        if (t instanceof JSONObject) {
            return this.evaluate(mpc, (JSONObject)t, msg);
        }
        if (t instanceof JSONArray) {
            return this.evaluate(mpc, (JSONArray)t, msg);
        }
        if (t instanceof String) {
            String key = t.toString();
            String val = mpc.evalExpression(key);
            return val == null ? "" : val;
        }
        return t;
    }
}

