/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.filters;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.processor.engine.model.Filter;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import org.json.JSONObject;

public class RangeLimit
implements Filter {
    private final String fKey;
    private final double fMin;
    private final double fMax;

    public RangeLimit(String key, double min, double max) {
        this.fKey = key;
        this.fMin = min;
        this.fMax = max;
    }

    public RangeLimit(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        this.fKey = config.getString("key");
        this.fMin = config.optDouble("min");
        this.fMax = config.optDouble("max");
    }

    public JSONObject toJson() {
        JSONObject result = new JSONObject().put("class", (Object)this.getClass().getName()).put("key", (Object)this.fKey);
        if (!Double.isNaN(this.fMin)) {
            result.put("min", this.fMin);
        }
        if (!Double.isNaN(this.fMax)) {
            result.put("max", this.fMax);
        }
        return result;
    }

    @Override
    public boolean passes(MessageProcessingContext ctx) {
        double val = ctx.getMessage().getDouble(this.fKey, Double.NaN);
        if (Double.isNaN(val)) {
            return false;
        }
        if (!Double.isNaN(this.fMin) && val < this.fMin) {
            return false;
        }
        return Double.isNaN(this.fMax) || !(val > this.fMax);
    }
}

