/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import coil.ImageLoader;
import coil.decode.AssetMetadata;
import coil.decode.ContentMetadata;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.ImageSource;
import coil.decode.ResourceMetadata;
import coil.fetch.SourceResult;
import coil.request.Options;
import coil.request.Videos;
import coil.size.-Sizes;
import coil.size.Dimension;
import coil.size.Scale;
import coil.size.Size;
import coil.util.-VideoUtils;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcoil/decode/VideoFrameDecoder;", "Lcoil/decode/Decoder;", "source", "Lcoil/decode/ImageSource;", "options", "Lcoil/request/Options;", "(Lcoil/decode/ImageSource;Lcoil/request/Options;)V", "decode", "Lcoil/decode/DecodeResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isConfigValid", "", "bitmap", "Landroid/graphics/Bitmap;", "isSizeValid", "size", "Lcoil/size/Size;", "normalizeBitmap", "inBitmap", "setDataSource", "", "Landroid/media/MediaMetadataRetriever;", "Companion", "Factory", "coil-video_release"})
public final class VideoFrameDecoder
implements Decoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageSource source;
    @NotNull
    private final Options options;
    @NotNull
    public static final String VIDEO_FRAME_MICROS_KEY = "coil#video_frame_micros";
    @NotNull
    public static final String VIDEO_FRAME_OPTION_KEY = "coil#video_frame_option";

    public VideoFrameDecoder(@NotNull ImageSource source, @NotNull Options options) {
        this.source = source;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Object decode(@NotNull Continuation<? super DecodeResult> $completion) {
        DecodeResult decodeResult;
        MediaMetadataRetriever $this$use$iv = new MediaMetadataRetriever();
        boolean $i$f$use = false;
        try {
            void $this$toDrawable$iv;
            Bitmap rawBitmap;
            Bitmap bitmap;
            Size size;
            int n;
            MediaMetadataRetriever retriever = $this$use$iv;
            boolean bl = false;
            this.setDataSource(retriever, this.source);
            Integer n2 = Videos.videoFrameOption(this.options.getParameters());
            int option = n2 == null ? 2 : n2;
            Long l = Videos.videoFrameMicros(this.options.getParameters());
            long frameMicros = l == null ? 0L : l;
            int srcWidth = 0;
            int srcHeight = 0;
            String string = retriever.extractMetadata(24);
            if (string == null) {
                n = 0;
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)string);
                n = n3 == null ? 0 : n3;
            }
            int rotation = n;
            switch (rotation) {
                case 90: 
                case 270: {
                    int n4;
                    int n5;
                    String string2 = retriever.extractMetadata(19);
                    if (string2 == null) {
                        n5 = 0;
                    } else {
                        Integer n6 = StringsKt.toIntOrNull((String)string2);
                        n5 = n6 == null ? 0 : n6;
                    }
                    srcWidth = n5;
                    String string3 = retriever.extractMetadata(18);
                    if (string3 == null) {
                        n4 = 0;
                    } else {
                        Integer n7 = StringsKt.toIntOrNull((String)string3);
                        n4 = n7 == null ? 0 : n7;
                    }
                    srcHeight = n4;
                    break;
                }
                default: {
                    int n8;
                    int n9;
                    String string4 = retriever.extractMetadata(18);
                    if (string4 == null) {
                        n9 = 0;
                    } else {
                        Integer n10 = StringsKt.toIntOrNull((String)string4);
                        n9 = n10 == null ? 0 : n10;
                    }
                    srcWidth = n9;
                    String string5 = retriever.extractMetadata(19);
                    if (string5 == null) {
                        n8 = 0;
                        break;
                    }
                    Integer n11 = StringsKt.toIntOrNull((String)string5);
                    n8 = srcHeight = n11 == null ? 0 : n11;
                }
            }
            if (srcWidth > 0 && srcHeight > 0) {
                int n12;
                void $this$heightPx$iv;
                int n13;
                void $this$widthPx$iv;
                Size size2 = this.options.getSize();
                Scale scale$iv = this.options.getScale();
                boolean $i$f$widthPx = false;
                if (-Sizes.isOriginal((Size)$this$widthPx$iv)) {
                    boolean bl2 = false;
                    n13 = srcWidth;
                } else {
                    n13 = -VideoUtils.toPx($this$widthPx$iv.getWidth(), scale$iv);
                }
                int dstWidth = n13;
                scale$iv = this.options.getSize();
                Scale scale$iv2 = this.options.getScale();
                boolean $i$f$heightPx = false;
                if (-Sizes.isOriginal((Size)$this$heightPx$iv)) {
                    boolean bl3 = false;
                    n12 = srcHeight;
                } else {
                    n12 = -VideoUtils.toPx($this$heightPx$iv.getHeight(), scale$iv2);
                }
                int dstHeight = n12;
                double rawScale = DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)dstWidth, (int)dstHeight, (Scale)this.options.getScale());
                double scale = this.options.getAllowInexactSize() ? RangesKt.coerceAtMost((double)rawScale, (double)1.0) : rawScale;
                int width = MathKt.roundToInt((double)(scale * (double)srcWidth));
                int height = MathKt.roundToInt((double)(scale * (double)srcHeight));
                size = -Sizes.Size((int)width, (int)height);
            } else {
                size = Size.ORIGINAL;
            }
            Size dstSize = size;
            Dimension dstWidth = dstSize.component1();
            Dimension dstHeight = dstSize.component2();
            if (Build.VERSION.SDK_INT >= 27 && dstWidth instanceof Dimension.Pixels && dstHeight instanceof Dimension.Pixels) {
                bitmap = retriever.getScaledFrameAtTime(frameMicros, option, ((Dimension.Pixels)dstWidth).px, ((Dimension.Pixels)dstHeight).px);
            } else {
                Bitmap bitmap2 = retriever.getFrameAtTime(frameMicros, option);
                if (bitmap2 == null) {
                    bitmap = null;
                } else {
                    Bitmap $i$f$heightPx;
                    Bitmap it = $i$f$heightPx = bitmap2;
                    boolean bl4 = false;
                    srcWidth = it.getWidth();
                    srcHeight = it.getHeight();
                    bitmap = $i$f$heightPx;
                }
            }
            if ((rawBitmap = bitmap) == null) {
                boolean $i$a$-checkNotNull-VideoFrameDecoder$decode$2$22 = false;
                String $i$a$-checkNotNull-VideoFrameDecoder$decode$2$22 = "Failed to decode frame at " + frameMicros + " microseconds.";
                throw new IllegalStateException($i$a$-checkNotNull-VideoFrameDecoder$decode$2$22.toString());
            }
            Bitmap bitmap3 = this.normalizeBitmap(rawBitmap, dstSize);
            boolean isSampled = srcWidth > 0 && srcHeight > 0 ? DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)bitmap3.getWidth(), (int)bitmap3.getHeight(), (Scale)this.options.getScale()) < 1.0 : true;
            Bitmap it = bitmap3;
            Resources resources$iv = this.options.getContext().getResources();
            boolean $i$f$toDrawable = false;
            decodeResult = new DecodeResult((Drawable)new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv), isSampled);
        }
        finally {
            if (Build.VERSION.SDK_INT >= 29) {
                $this$use$iv.close();
            } else {
                $this$use$iv.release();
            }
        }
        return decodeResult;
    }

    private final Bitmap normalizeBitmap(Bitmap inBitmap, Size size) {
        Canvas c$iv;
        Bitmap outBitmap;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.isConfigValid(inBitmap, this.options) && this.isSizeValid(inBitmap, this.options, size)) {
            return inBitmap;
        }
        int n6 = inBitmap.getWidth();
        int n7 = inBitmap.getHeight();
        Dimension $this$pxOrElse$iv = size.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = inBitmap.getWidth();
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = inBitmap.getHeight();
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        float scale = (float)DecodeUtils.computeSizeMultiplier((int)n6, (int)n7, (int)n5, (int)n, (Scale)this.options.getScale());
        int dstWidth = MathKt.roundToInt((float)(scale * (float)inBitmap.getWidth()));
        int dstHeight = MathKt.roundToInt((float)(scale * (float)inBitmap.getHeight()));
        Bitmap.Config safeConfig = Build.VERSION.SDK_INT >= 26 && this.options.getConfig() == Bitmap.Config.HARDWARE ? Bitmap.Config.ARGB_8888 : this.options.getConfig();
        Paint paint = new Paint(3);
        boolean $i$f$createBitmap = false;
        Bitmap bitmap = Bitmap.createBitmap((int)dstWidth, (int)dstHeight, (Bitmap.Config)safeConfig);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, height, config)");
        Bitmap $this$applyCanvas$iv = outBitmap = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$normalizeBitmap_u24lambda_u2d7 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$normalizeBitmap_u24lambda_u2d7.scale(scale, scale);
        $this$normalizeBitmap_u24lambda_u2d7.drawBitmap(inBitmap, 0.0f, 0.0f, paint);
        inBitmap.recycle();
        return outBitmap;
    }

    private final boolean isConfigValid(Bitmap bitmap, Options options) {
        return Build.VERSION.SDK_INT < 26 || bitmap.getConfig() != Bitmap.Config.HARDWARE || options.getConfig() == Bitmap.Config.HARDWARE;
    }

    private final boolean isSizeValid(Bitmap bitmap, Options options, Size size) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (options.getAllowInexactSize()) {
            return true;
        }
        int n6 = bitmap.getWidth();
        int n7 = bitmap.getHeight();
        Dimension $this$pxOrElse$iv = size.getWidth();
        boolean $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n5 = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            n2 = bitmap.getWidth();
            n6 = n3;
            n7 = n4;
            n5 = n2;
        }
        $this$pxOrElse$iv = size.getHeight();
        $i$f$pxOrElse = false;
        if ($this$pxOrElse$iv instanceof Dimension.Pixels) {
            n = ((Dimension.Pixels)$this$pxOrElse$iv).px;
        } else {
            n2 = n5;
            n4 = n7;
            n3 = n6;
            boolean bl = false;
            int n8 = bitmap.getHeight();
            n6 = n3;
            n7 = n4;
            n5 = n2;
            n = n8;
        }
        double multiplier = DecodeUtils.computeSizeMultiplier((int)n6, (int)n7, (int)n5, (int)n, (Scale)options.getScale());
        return multiplier == 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setDataSource(MediaMetadataRetriever $this$setDataSource, ImageSource source) {
        ImageSource.Metadata metadata = source.getMetadata();
        if (metadata instanceof AssetMetadata) {
            Closeable closeable = (Closeable)this.options.getContext().getAssets().openFd(((AssetMetadata)metadata).getFileName());
            Throwable throwable = null;
            try {
                AssetFileDescriptor it = (AssetFileDescriptor)closeable;
                boolean bl = false;
                $this$setDataSource.setDataSource(it.getFileDescriptor(), it.getStartOffset(), it.getLength());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (metadata instanceof ContentMetadata) {
            $this$setDataSource.setDataSource(this.options.getContext(), ((ContentMetadata)metadata).getUri());
        } else if (metadata instanceof ResourceMetadata) {
            $this$setDataSource.setDataSource("android.resource://" + ((ResourceMetadata)metadata).getPackageName() + '/' + ((ResourceMetadata)metadata).getResId());
        } else {
            $this$setDataSource.setDataSource(source.file().toFile().getPath());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcoil/decode/VideoFrameDecoder$Factory;", "Lcoil/decode/Decoder$Factory;", "()V", "create", "Lcoil/decode/Decoder;", "result", "Lcoil/fetch/SourceResult;", "options", "Lcoil/request/Options;", "imageLoader", "Lcoil/ImageLoader;", "equals", "", "other", "", "hashCode", "", "isApplicable", "mimeType", "", "coil-video_release"})
    public static final class Factory
    implements Decoder.Factory {
        @Nullable
        public Decoder create(@NotNull SourceResult result, @NotNull Options options, @NotNull ImageLoader imageLoader) {
            if (!this.isApplicable(result.getMimeType())) {
                return null;
            }
            return new VideoFrameDecoder(result.getSource(), options);
        }

        private final boolean isApplicable(String mimeType) {
            return mimeType != null && StringsKt.startsWith$default((String)mimeType, (String)"video/", (boolean)false, (int)2, null);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Factory;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcoil/decode/VideoFrameDecoder$Companion;", "", "()V", "VIDEO_FRAME_MICROS_KEY", "", "VIDEO_FRAME_OPTION_KEY", "coil-video_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

