/*
 * Decompiled with CFR 0.152.
 */
package coil.fetch;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import coil.bitmappool.BitmapPool;
import coil.decode.DataSource;
import coil.decode.DecodeUtils;
import coil.decode.Options;
import coil.extension.Videos;
import coil.fetch.DrawableResult;
import coil.fetch.FetchResult;
import coil.fetch.Fetcher;
import coil.size.OriginalSize;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001eB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J1\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0019\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcoil/fetch/VideoFrameFetcher;", "T", "", "Lcoil/fetch/Fetcher;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "paint", "Landroid/graphics/Paint;", "fetch", "Lcoil/fetch/FetchResult;", "pool", "Lcoil/bitmappool/BitmapPool;", "data", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmappool/BitmapPool;Ljava/lang/Object;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isConfigValid", "", "bitmap", "Landroid/graphics/Bitmap;", "isSizeValid", "normalizeBitmap", "inBitmap", "setDataSource", "", "Landroid/media/MediaMetadataRetriever;", "(Landroid/media/MediaMetadataRetriever;Ljava/lang/Object;)V", "Companion", "coil-video_release"})
public abstract class VideoFrameFetcher<T>
implements Fetcher<T> {
    private final Paint paint;
    private final Context context;
    @JvmField
    @NotNull
    public static final String[] SUPPORTED_FILE_EXTENSIONS;
    @NotNull
    public static final String ASSET_FILE_PATH_ROOT = "android_asset";
    @NotNull
    public static final String VIDEO_FRAME_MICROS_KEY = "coil#video_frame_micros";
    @NotNull
    public static final String VIDEO_FRAME_OPTION_KEY = "coil#video_frame_option";
    public static final Companion Companion;

    protected abstract void setDataSource(@NotNull MediaMetadataRetriever var1, @NotNull T var2);

    @Nullable
    public Object fetch(@NotNull BitmapPool bitmapPool, @NotNull T t, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super FetchResult> $completion) {
        return VideoFrameFetcher.fetch$suspendImpl(this, bitmapPool, t, size, options, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    static /* synthetic */ Object fetch$suspendImpl(VideoFrameFetcher this_, BitmapPool pool, Object data, Size size, Options options, Continuation $completion) {
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            void $this$toDrawable$iv;
            boolean bl;
            Bitmap bitmap;
            Size size2;
            this_.setDataSource(retriever, data);
            Integer n = Videos.videoFrameOption(options.getParameters());
            int option = n != null ? n : 2;
            Long l = Videos.videoFrameMicros(options.getParameters());
            long frameMicros = l != null ? l : 0L;
            int srcWidth = 0;
            int srcHeight = 0;
            Size size3 = size;
            if (size3 instanceof PixelSize) {
                Object object = retriever.extractMetadata(18);
                srcWidth = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                Object object2 = retriever.extractMetadata(19);
                int n2 = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : (srcHeight = 0);
                if (srcWidth > 0 && srcHeight > 0) {
                    double rawScale = DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)((PixelSize)size).getWidth(), (int)((PixelSize)size).getHeight(), (Scale)options.getScale());
                    double scale = options.getAllowInexactSize() ? RangesKt.coerceAtMost((double)rawScale, (double)1.0) : rawScale;
                    int width = MathKt.roundToInt((double)(scale * (double)srcWidth));
                    int height = MathKt.roundToInt((double)(scale * (double)srcHeight));
                    size2 = (Size)new PixelSize(width, height);
                } else {
                    size2 = (Size)OriginalSize.INSTANCE;
                }
            } else if (size3 instanceof OriginalSize) {
                size2 = (Size)OriginalSize.INSTANCE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Size destSize = size2;
            if (Build.VERSION.SDK_INT >= 27 && destSize instanceof PixelSize) {
                bitmap = retriever.getScaledFrameAtTime(frameMicros, option, ((PixelSize)destSize).getWidth(), ((PixelSize)destSize).getHeight());
            } else {
                Bitmap bitmap2 = retriever.getFrameAtTime(frameMicros, option);
                if (bitmap2 != null) {
                    Bitmap rawScale = bitmap2;
                    bl = false;
                    boolean scale = false;
                    Bitmap it = rawScale;
                    boolean bl2 = false;
                    srcWidth = it.getWidth();
                    srcHeight = it.getHeight();
                    bitmap = rawScale;
                } else {
                    bitmap = null;
                }
            }
            Bitmap rawBitmap = bitmap;
            boolean rawScale = false;
            bl = false;
            if (rawBitmap == null) {
                boolean bl3 = false;
                String string = "Failed to decode frame at " + frameMicros + " microseconds.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Bitmap bitmap3 = this_.normalizeBitmap(pool, rawBitmap, destSize, options);
            boolean isSampled = srcWidth > 0 && srcHeight > 0 ? DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)bitmap3.getWidth(), (int)bitmap3.getHeight(), (Scale)options.getScale()) < 1.0 : true;
            Bitmap bl3 = bitmap3;
            Resources resources = this_.context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            Resources resources$iv = resources;
            boolean $i$f$toDrawable = false;
            BitmapDrawable bitmapDrawable = new BitmapDrawable(resources$iv, (Bitmap)$this$toDrawable$iv);
            DataSource dataSource = DataSource.DISK;
            boolean bl4 = isSampled;
            Drawable drawable = (Drawable)bitmapDrawable;
            DrawableResult drawableResult = new DrawableResult(drawable, bl4, dataSource);
            return drawableResult;
        }
        finally {
            retriever.release();
        }
    }

    private final Bitmap normalizeBitmap(BitmapPool pool, Bitmap inBitmap, Size size, Options options) {
        Canvas c$iv;
        Bitmap outBitmap;
        if (this.isConfigValid(inBitmap, options) && this.isSizeValid(inBitmap, options, size)) {
            return inBitmap;
        }
        float scale = 0.0f;
        int dstWidth = 0;
        int dstHeight = 0;
        Size size2 = size;
        if (size2 instanceof PixelSize) {
            scale = (float)DecodeUtils.computeSizeMultiplier((int)inBitmap.getWidth(), (int)inBitmap.getHeight(), (int)((PixelSize)size).getWidth(), (int)((PixelSize)size).getHeight(), (Scale)options.getScale());
            dstWidth = MathKt.roundToInt((float)(scale * (float)inBitmap.getWidth()));
            dstHeight = MathKt.roundToInt((float)(scale * (float)inBitmap.getHeight()));
        } else if (size2 instanceof OriginalSize) {
            scale = 1.0f;
            dstWidth = inBitmap.getWidth();
            dstHeight = inBitmap.getHeight();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Bitmap.Config safeConfig = Build.VERSION.SDK_INT >= 26 && options.getConfig() == Bitmap.Config.HARDWARE ? Bitmap.Config.ARGB_8888 : options.getConfig();
        Bitmap $this$applyCanvas$iv = outBitmap = pool.get(dstWidth, dstHeight, safeConfig);
        boolean $i$f$applyCanvas = false;
        Canvas $this$applyCanvas = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        $this$applyCanvas.scale(scale, scale);
        $this$applyCanvas.drawBitmap(inBitmap, 0.0f, 0.0f, this.paint);
        pool.put(inBitmap);
        return outBitmap;
    }

    private final boolean isConfigValid(Bitmap bitmap, Options options) {
        return Build.VERSION.SDK_INT < 26 || bitmap.getConfig() != Bitmap.Config.HARDWARE || options.getConfig() == Bitmap.Config.HARDWARE;
    }

    private final boolean isSizeValid(Bitmap bitmap, Options options, Size size) {
        return options.getAllowInexactSize() || size instanceof OriginalSize || Intrinsics.areEqual((Object)size, (Object)DecodeUtils.computePixelSize((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Size)size, (Scale)options.getScale()));
    }

    public VideoFrameFetcher(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.paint = new Paint(3);
    }

    static {
        Companion = new Companion(null);
        SUPPORTED_FILE_EXTENSIONS = new String[]{".3gp", ".mkv", ".mp4", ".ts", ".webm"};
    }

    public boolean handles(@NotNull T data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        return Fetcher.DefaultImpls.handles((Fetcher)this, data);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00068\u0000X\u0081\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcoil/fetch/VideoFrameFetcher$Companion;", "", "()V", "ASSET_FILE_PATH_ROOT", "", "SUPPORTED_FILE_EXTENSIONS", "", "[Ljava/lang/String;", "VIDEO_FRAME_MICROS_KEY", "VIDEO_FRAME_OPTION_KEY", "coil-video_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

