/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Movie;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import coil.transform.AnimatedTransformation;
import coil.transform.PixelOpacity;
import coil.util.-GifExtensions;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB-\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002042\u0006\u00106\u001a\u00020,H\u0016J\u0010\u00107\u001a\u0002042\u0006\u00106\u001a\u00020,H\u0002J\b\u00108\u001a\u0004\u0018\u00010\rJ\b\u00109\u001a\u00020!H\u0016J\b\u0010:\u001a\u00020!H\u0016J\b\u0010;\u001a\u00020!H\u0016J\u0006\u0010<\u001a\u00020!J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020\u0012H\u0016J\u0010\u0010?\u001a\u0002042\u0006\u0010@\u001a\u00020!H\u0016J\u0010\u0010A\u001a\u0002042\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010B\u001a\u0002042\b\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u000e\u0010E\u001a\u0002042\u0006\u0010&\u001a\u00020!J\b\u0010F\u001a\u000204H\u0016J\b\u0010G\u001a\u000204H\u0016J\u0010\u0010H\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0012H\u0016J\u0010\u0010I\u001a\u0002042\u0006\u00100\u001a\u00020\u0016H\u0002J\b\u0010J\u001a\u00020\u001eH\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00100\u001a\u00020\u0016*\u00020,8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102\u00a8\u0006L"}, d2={"Lcoil/drawable/MovieDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat;", "movie", "Landroid/graphics/Movie;", "pool", "Lcoil/bitmap/BitmapPool;", "config", "Landroid/graphics/Bitmap$Config;", "scale", "Lcoil/size/Scale;", "(Landroid/graphics/Movie;Lcoil/bitmap/BitmapPool;Landroid/graphics/Bitmap$Config;Lcoil/size/Scale;)V", "animatedTransformation", "Lcoil/transform/AnimatedTransformation;", "animatedTransformationPicture", "Landroid/graphics/Picture;", "callbacks", "", "Landroidx/vectordrawable/graphics/drawable/Animatable2Compat$AnimationCallback;", "getConfig", "()Landroid/graphics/Bitmap$Config;", "currentBounds", "Landroid/graphics/Rect;", "frameTimeMillis", "", "hardwareDx", "", "hardwareDy", "hardwareScale", "isRunning", "", "isSoftwareScalingEnabled", "loopIteration", "", "paint", "Landroid/graphics/Paint;", "pixelOpacity", "Lcoil/transform/PixelOpacity;", "repeatCount", "getScale", "()Lcoil/size/Scale;", "softwareBitmap", "Landroid/graphics/Bitmap;", "softwareCanvas", "Landroid/graphics/Canvas;", "softwareScale", "startTimeMillis", "tempCanvasBounds", "bounds", "getBounds", "(Landroid/graphics/Canvas;)Landroid/graphics/Rect;", "clearAnimationCallbacks", "", "draw", "canvas", "drawFrame", "getAnimatedTransformation", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "getRepeatCount", "registerAnimationCallback", "callback", "setAlpha", "alpha", "setAnimatedTransformation", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setRepeatCount", "start", "stop", "unregisterAnimationCallback", "updateBounds", "updateFrameTime", "Companion", "coil-gif_release"})
public final class MovieDrawable
extends Drawable
implements Animatable2Compat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Movie movie;
    @NotNull
    private final BitmapPool pool;
    @NotNull
    private final Bitmap.Config config;
    @NotNull
    private final Scale scale;
    @NotNull
    private final Paint paint;
    @NotNull
    private final List<Animatable2Compat.AnimationCallback> callbacks;
    @NotNull
    private final Rect currentBounds;
    @NotNull
    private final Rect tempCanvasBounds;
    @Nullable
    private Canvas softwareCanvas;
    @Nullable
    private Bitmap softwareBitmap;
    private float softwareScale;
    private float hardwareScale;
    private float hardwareDx;
    private float hardwareDy;
    private boolean isRunning;
    private long startTimeMillis;
    private long frameTimeMillis;
    private int repeatCount;
    private int loopIteration;
    @Nullable
    private AnimatedTransformation animatedTransformation;
    @Nullable
    private Picture animatedTransformationPicture;
    @NotNull
    private PixelOpacity pixelOpacity;
    private boolean isSoftwareScalingEnabled;
    public static final int REPEAT_INFINITE = -1;

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie, @NotNull BitmapPool pool, @NotNull Bitmap.Config config, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)movie, (String)"movie");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.movie = movie;
        this.pool = pool;
        this.config = config;
        this.scale = scale;
        this.paint = new Paint(3);
        boolean bl = false;
        this.callbacks = new ArrayList();
        this.currentBounds = new Rect();
        this.tempCanvasBounds = new Rect();
        this.softwareScale = 1.0f;
        this.hardwareScale = 1.0f;
        this.repeatCount = -1;
        this.pixelOpacity = PixelOpacity.UNCHANGED;
        bl = !-GifExtensions.isHardware(this.config);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bitmap config must not be hardware.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ MovieDrawable(Movie movie, BitmapPool bitmapPool, Bitmap.Config config, Scale scale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bitmapPool = BitmapPool.Companion.create(0);
        }
        if ((n & 4) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        if ((n & 8) != 0) {
            scale = Scale.FIT;
        }
        this(movie, bitmapPool, config, scale);
    }

    @NotNull
    public final Bitmap.Config getConfig() {
        return this.config;
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        boolean invalidate = this.updateFrameTime();
        if (this.isSoftwareScalingEnabled) {
            this.updateBounds(this.getBounds(canvas));
            Canvas $this$withSave$iv = canvas;
            boolean $i$f$withSave = false;
            int checkpoint$iv = $this$withSave$iv.save();
            try {
                Canvas $this$draw_u24lambda_u2d1 = $this$withSave$iv;
                boolean bl = false;
                float scale = 1.0f / this.softwareScale;
                $this$draw_u24lambda_u2d1.scale(scale, scale);
                this.drawFrame(canvas);
            }
            finally {
                $this$withSave$iv.restoreToCount(checkpoint$iv);
            }
        } else {
            Rect rect = this.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
            this.updateBounds(rect);
            this.drawFrame(canvas);
        }
        if (this.isRunning && invalidate) {
            this.invalidateSelf();
        } else {
            this.stop();
        }
    }

    private final boolean updateFrameTime() {
        boolean invalidate = false;
        int time = 0;
        int duration = this.movie.duration();
        if (duration == 0) {
            invalidate = false;
            time = 0;
        } else {
            if (this.isRunning) {
                this.frameTimeMillis = SystemClock.uptimeMillis();
            }
            int elapsedTime = (int)(this.frameTimeMillis - this.startTimeMillis);
            this.loopIteration = elapsedTime / duration;
            invalidate = this.repeatCount == -1 || this.loopIteration <= this.repeatCount;
            time = invalidate ? elapsedTime - this.loopIteration * duration : duration;
        }
        this.movie.setTime(time);
        return invalidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawFrame(Canvas canvas) {
        Canvas softwareCanvas = this.softwareCanvas;
        Bitmap softwareBitmap = this.softwareBitmap;
        if (softwareCanvas == null || softwareBitmap == null) {
            return;
        }
        softwareCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        Canvas $this$withSave$iv = softwareCanvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawFrame_u24lambda_u2d2 = $this$withSave$iv;
            boolean bl = false;
            $this$drawFrame_u24lambda_u2d2.scale(this.softwareScale, this.softwareScale);
            this.movie.draw($this$drawFrame_u24lambda_u2d2, 0.0f, 0.0f, this.paint);
            Picture picture = this.animatedTransformationPicture;
            if (picture == null) {
            } else {
                picture.draw($this$drawFrame_u24lambda_u2d2);
            }
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
        $this$withSave$iv = canvas;
        $i$f$withSave = false;
        checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawFrame_u24lambda_u2d3 = $this$withSave$iv;
            boolean bl = false;
            $this$drawFrame_u24lambda_u2d3.translate(this.hardwareDx, this.hardwareDy);
            $this$drawFrame_u24lambda_u2d3.scale(this.hardwareScale, this.hardwareScale);
            $this$drawFrame_u24lambda_u2d3.drawBitmap(softwareBitmap, 0.0f, 0.0f, this.paint);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    public final void setRepeatCount(int repeatCount) {
        boolean bl = repeatCount >= -1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid repeatCount: ", (Object)repeatCount);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.repeatCount = repeatCount;
    }

    public final int getRepeatCount() {
        return this.repeatCount;
    }

    public final void setAnimatedTransformation(@Nullable AnimatedTransformation animatedTransformation) {
        this.animatedTransformation = animatedTransformation;
        if (animatedTransformation != null && this.movie.width() > 0 && this.movie.height() > 0) {
            Picture picture = new Picture();
            Canvas canvas = picture.beginRecording(this.movie.width(), this.movie.height());
            Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"picture.beginRecording(movie.width(), movie.height())");
            Canvas canvas2 = canvas;
            this.pixelOpacity = animatedTransformation.transform(canvas2);
            picture.endRecording();
            this.animatedTransformationPicture = picture;
            this.isSoftwareScalingEnabled = true;
        } else {
            this.animatedTransformationPicture = null;
            this.pixelOpacity = PixelOpacity.UNCHANGED;
            this.isSoftwareScalingEnabled = false;
        }
        this.invalidateSelf();
    }

    @Nullable
    public final AnimatedTransformation getAnimatedTransformation() {
        return this.animatedTransformation;
    }

    public void setAlpha(int alpha) {
        boolean bl = 0 <= alpha ? alpha <= 255 : false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid alpha: ", (Object)alpha);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.paint.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.paint.getAlpha() == 255 && (this.pixelOpacity == PixelOpacity.OPAQUE || this.pixelOpacity == PixelOpacity.UNCHANGED && this.movie.isOpaque()) ? -1 : -3;
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    private final void updateBounds(Rect bounds) {
        double $this$updateBounds_u24lambda_u2d6;
        if (Intrinsics.areEqual((Object)this.currentBounds, (Object)bounds)) {
            return;
        }
        this.currentBounds.set(bounds);
        int boundsWidth = bounds.width();
        int boundsHeight = bounds.height();
        int movieWidth = this.movie.width();
        int movieHeight = this.movie.height();
        if (movieWidth <= 0 || movieHeight <= 0) {
            return;
        }
        double d = DecodeUtils.computeSizeMultiplier((int)movieWidth, (int)movieHeight, (int)boundsWidth, (int)boundsHeight, (Scale)this.scale);
        boolean bl = false;
        boolean bl2 = false;
        double d2 = d;
        MovieDrawable movieDrawable = this;
        boolean bl3 = false;
        void var18_16 = this.isSoftwareScalingEnabled ? $this$updateBounds_u24lambda_u2d6 : RangesKt.coerceAtMost((double)$this$updateBounds_u24lambda_u2d6, (double)1.0);
        movieDrawable.softwareScale = (float)var18_16;
        int bitmapWidth = (int)(this.softwareScale * (float)movieWidth);
        int bitmapHeight = (int)(this.softwareScale * (float)movieHeight);
        Bitmap bitmap = this.pool.get(bitmapWidth, bitmapHeight, this.config);
        Bitmap bitmap2 = this.softwareBitmap;
        if (bitmap2 != null) {
            Bitmap bitmap3 = bitmap2;
            BitmapPool bitmapPool = this.pool;
            boolean bl4 = false;
            boolean bl5 = false;
            Bitmap p0 = bitmap3;
            boolean bl6 = false;
            bitmapPool.put(p0);
        }
        this.softwareBitmap = bitmap;
        this.softwareCanvas = new Canvas(bitmap);
        if (this.isSoftwareScalingEnabled) {
            this.hardwareScale = 1.0f;
            this.hardwareDx = 0.0f;
            this.hardwareDy = 0.0f;
        } else {
            this.hardwareScale = (float)DecodeUtils.computeSizeMultiplier((int)bitmapWidth, (int)bitmapHeight, (int)boundsWidth, (int)boundsHeight, (Scale)this.scale);
            this.hardwareDx = (float)bounds.left + ((float)boundsWidth - this.hardwareScale * (float)bitmapWidth) / (float)2;
            this.hardwareDy = (float)bounds.top + ((float)boundsHeight - this.hardwareScale * (float)bitmapHeight) / (float)2;
        }
    }

    public int getIntrinsicWidth() {
        return this.movie.width();
    }

    public int getIntrinsicHeight() {
        return this.movie.height();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.loopIteration = 0;
        this.startTimeMillis = SystemClock.uptimeMillis();
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size() + -1;
        if (n <= n2) {
            do {
                int i$iv = n++;
                Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                it.onAnimationStart((Drawable)this);
            } while (n <= n2);
        }
        this.invalidateSelf();
    }

    public void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        List<Animatable2Compat.AnimationCallback> $this$forEachIndices$iv = this.callbacks;
        boolean $i$f$forEachIndices = false;
        int n = 0;
        int n2 = $this$forEachIndices$iv.size() + -1;
        if (n <= n2) {
            do {
                int i$iv = n++;
                Animatable2Compat.AnimationCallback it = $this$forEachIndices$iv.get(i$iv);
                boolean bl = false;
                it.onAnimationEnd((Drawable)this);
            } while (n <= n2);
        }
    }

    public void registerAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.add(callback);
    }

    public boolean unregisterAnimationCallback(@NotNull Animatable2Compat.AnimationCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return this.callbacks.remove(callback);
    }

    public void clearAnimationCallbacks() {
        this.callbacks.clear();
    }

    private final Rect getBounds(Canvas $this$bounds) {
        Rect rect = this.tempCanvasBounds;
        boolean bl = false;
        boolean bl2 = false;
        Rect $this$_get_bounds__u24lambda_u2d9 = rect;
        boolean bl3 = false;
        $this$_get_bounds__u24lambda_u2d9.set(0, 0, $this$bounds.getWidth(), $this$bounds.getHeight());
        return rect;
    }

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie, @NotNull BitmapPool pool, @NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)movie, (String)"movie");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this(movie, pool, config, null, 8, null);
    }

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie, @NotNull BitmapPool pool) {
        Intrinsics.checkNotNullParameter((Object)movie, (String)"movie");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this(movie, pool, null, null, 12, null);
    }

    @JvmOverloads
    public MovieDrawable(@NotNull Movie movie) {
        Intrinsics.checkNotNullParameter((Object)movie, (String)"movie");
        this(movie, null, null, null, 14, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/drawable/MovieDrawable$Companion;", "", "()V", "REPEAT_INFINITE", "", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

