/*
 * Decompiled with CFR 0.152.
 */
package coil.decode;

import android.graphics.Bitmap;
import android.graphics.ImageDecoder;
import android.graphics.drawable.AnimatedImageDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.RequiresApi;
import coil.bitmap.BitmapPool;
import coil.decode.DecodeResult;
import coil.decode.DecodeUtils;
import coil.decode.Decoder;
import coil.decode.InterruptibleSource;
import coil.decode.Options;
import coil.drawable.ScaleDrawable;
import coil.request.Gifs;
import coil.size.PixelSize;
import coil.size.Scale;
import coil.size.Size;
import java.io.Closeable;
import java.io.File;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.math.MathKt;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcoil/decode/ImageDecoderDecoder;", "Lcoil/decode/Decoder;", "()V", "decode", "Lcoil/decode/DecodeResult;", "pool", "Lcoil/bitmap/BitmapPool;", "source", "Lokio/BufferedSource;", "size", "Lcoil/size/Size;", "options", "Lcoil/decode/Options;", "(Lcoil/bitmap/BitmapPool;Lokio/BufferedSource;Lcoil/size/Size;Lcoil/decode/Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handles", "", "mimeType", "", "Companion", "coil-gif_release"})
@RequiresApi(value=28)
public final class ImageDecoderDecoder
implements Decoder {
    @NotNull
    public static final String REPEAT_COUNT_KEY = "coil#repeat_count";
    public static final Companion Companion = new Companion(null);

    public boolean handles(@NotNull BufferedSource source, @Nullable String mimeType) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return DecodeUtils.isGif((BufferedSource)source) || DecodeUtils.isAnimatedWebP((BufferedSource)source) || Build.VERSION.SDK_INT >= 30 && DecodeUtils.isAnimatedHeif((BufferedSource)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public Object decode(@NotNull BitmapPool pool, @NotNull BufferedSource source, @NotNull Size size, @NotNull Options options, @NotNull Continuation<? super DecodeResult> $completion) {
        boolean $i$f$withInterruptibleSource = false;
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super DecodeResult> uCont$iv$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv$iv), 1);
        cancellable$iv$iv.initCancellability();
        CancellableContinuation continuation$iv = (CancellableContinuation)cancellable$iv$iv;
        boolean bl2 = false;
        try {
            InterruptibleSource interruptibleSource$iv = new InterruptibleSource(continuation$iv, (Source)source);
            try {
                void tempFile;
                Ref.BooleanRef booleanRef;
                Continuation continuation = (Continuation)continuation$iv;
                Source interruptibleSource = (Source)interruptibleSource$iv;
                boolean bl3 = false;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                try {
                    Drawable drawable;
                    void isSampled;
                    ImageDecoder.Source decoderSource;
                    ImageDecoder.Source source2;
                    boolean bl4;
                    Closeable closeable;
                    booleanRef = new Ref.BooleanRef();
                    booleanRef.element = false;
                    BufferedSource bufferedSource = Okio.buffer((Source)interruptibleSource);
                    if (Build.VERSION.SDK_INT >= 30) {
                        closeable = (Closeable)bufferedSource;
                        bl4 = false;
                        boolean bl5 = false;
                        Throwable throwable = null;
                        try {
                            Object it = (BufferedSource)closeable;
                            boolean bl6 = false;
                            it = it.readByteArray();
                        }
                        catch (Throwable it) {
                            throwable = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        source2 = ImageDecoder.createSource((ByteBuffer)ByteBuffer.wrap((byte[])it));
                    } else {
                        tempFile.element = FilesKt.createTempFile$default(null, null, null, (int)7, null);
                        closeable = (Closeable)bufferedSource;
                        bl4 = false;
                        boolean bl7 = false;
                        Throwable throwable = null;
                        try {
                            Long l;
                            BufferedSource it = (BufferedSource)closeable;
                            boolean bl8 = false;
                            Closeable closeable2 = (Closeable)Okio.sink$default((File)((File)tempFile.element), (boolean)false, (int)1, null);
                            boolean bl9 = false;
                            boolean bl10 = false;
                            Throwable throwable2 = null;
                            try {
                                Sink p1 = (Sink)closeable2;
                                boolean bl11 = false;
                                l = Boxing.boxLong((long)it.readAll(p1));
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                            }
                            Long l2 = Boxing.boxLong((long)((Number)l).longValue());
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        source2 = ImageDecoder.createSource((File)((File)tempFile.element));
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)source2, (String)"if (SDK_INT >= 30) {\n   \u2026e(tempFile)\n            }");
                    ImageDecoder.Source $this$decodeDrawable$iv = decoderSource = source2;
                    boolean $i$f$decodeDrawable = false;
                    Drawable drawable2 = ImageDecoder.decodeDrawable((ImageDecoder.Source)$this$decodeDrawable$iv, (ImageDecoder.OnHeaderDecodedListener)new ImageDecoder.OnHeaderDecodedListener((Ref.ObjectRef)tempFile, (Ref.BooleanRef)isSampled, size, options){
                        final /* synthetic */ Ref.ObjectRef $tempFile$inlined;
                        final /* synthetic */ Ref.BooleanRef $isSampled$inlined;
                        final /* synthetic */ Size $size$inlined;
                        final /* synthetic */ Options $options$inlined;
                        {
                            this.$tempFile$inlined = objectRef;
                            this.$isSampled$inlined = booleanRef;
                            this.$size$inlined = size;
                            this.$options$inlined = options;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void onHeaderDecoded(@NotNull ImageDecoder decoder, @NotNull ImageDecoder.ImageInfo info, @NotNull ImageDecoder.Source source) {
                            Intrinsics.checkParameterIsNotNull((Object)decoder, (String)"decoder");
                            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                            ImageDecoder.Source source2 = source;
                            ImageDecoder.ImageInfo imageInfo = info;
                            ImageDecoder $this$decodeDrawable = decoder;
                            boolean bl = false;
                            File file = (File)this.$tempFile$inlined.element;
                            if (file != null) {
                                file.delete();
                            }
                            if (this.$size$inlined instanceof PixelSize) {
                                void srcWidth;
                                void info2;
                                android.util.Size size;
                                android.util.Size $this$component1$iv = size = info2.getSize();
                                boolean $i$f$component1 = false;
                                int n = $this$component1$iv.getWidth();
                                android.util.Size $this$component2$iv = size;
                                boolean $i$f$component2 = false;
                                int srcHeight = $this$component2$iv.getHeight();
                                double multiplier = DecodeUtils.computeSizeMultiplier((int)srcWidth, (int)srcHeight, (int)((PixelSize)this.$size$inlined).getWidth(), (int)((PixelSize)this.$size$inlined).getHeight(), (Scale)this.$options$inlined.getScale());
                                boolean bl2 = this.$isSampled$inlined.element = multiplier < 1.0;
                                if (this.$isSampled$inlined.element || !this.$options$inlined.getAllowInexactSize()) {
                                    int targetWidth = MathKt.roundToInt((double)(multiplier * (double)srcWidth));
                                    int targetHeight = MathKt.roundToInt((double)(multiplier * (double)srcHeight));
                                    $this$decodeDrawable.setTargetSize(targetWidth, targetHeight);
                                }
                            }
                            $this$decodeDrawable.setAllocator(this.$options$inlined.getConfig() == Bitmap.Config.HARDWARE ? 3 : 1);
                            $this$decodeDrawable.setMemorySizePolicy(this.$options$inlined.getAllowRgb565() ? 0 : 1);
                            if (this.$options$inlined.getColorSpace() != null) {
                                $this$decodeDrawable.setTargetColorSpace(this.$options$inlined.getColorSpace());
                            }
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ImageDecoder.decodeDrawa\u2026ction(info, source)\n    }");
                    Drawable baseDrawable = drawable2;
                    if (baseDrawable instanceof AnimatedImageDrawable) {
                        Integer n = Gifs.repeatCount(options.getParameters());
                        ((AnimatedImageDrawable)baseDrawable).setRepeatCount(n != null ? n : -1);
                        drawable = new ScaleDrawable(baseDrawable, options.getScale());
                    } else {
                        drawable = baseDrawable;
                    }
                    Drawable drawable3 = drawable;
                    booleanRef = new DecodeResult(drawable3, isSampled.element);
                }
                finally {
                    File file = (File)tempFile.element;
                    if (file != null) {
                        Boxing.boxBoolean((boolean)file.delete());
                    }
                }
                Ref.BooleanRef booleanRef2 = booleanRef;
                boolean bl12 = false;
                objectRef = Result.Companion;
                boolean bl13 = false;
                continuation.resumeWith(Result.constructor-impl((Object)booleanRef2));
            }
            finally {
                interruptibleSource$iv.clearInterrupt();
            }
        }
        catch (Exception exception$iv) {
            if (exception$iv instanceof InterruptedException || exception$iv instanceof InterruptedIOException) {
                Throwable throwable = new CancellationException("Blocking call was interrupted due to parent cancellation.").initCause(exception$iv);
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"CancellationException(\"B\u2026n.\").initCause(exception)");
                throw throwable;
            }
            throw (Throwable)exception$iv;
        }
        Object object = cancellable$iv$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcoil/decode/ImageDecoderDecoder$Companion;", "", "()V", "REPEAT_COUNT_KEY", "", "coil-gif_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

