/*
 * Decompiled with CFR 0.152.
 */
package coil.drawable;

import android.content.res.ColorStateList;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import coil.decode.DecodeUtils;
import coil.size.Scale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0017J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0017J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0001H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0013H\u0014J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0014J \u0010%\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u0013H\u0016J\u0012\u0010,\u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u0015H\u0017J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u0013H\u0017J\u0012\u00100\u001a\u00020\u000f2\b\u00101\u001a\u0004\u0018\u000102H\u0017J\u0012\u00103\u001a\u00020\u000f2\b\u00104\u001a\u0004\u0018\u000105H\u0017J\u0012\u00106\u001a\u00020\u000f2\b\u00107\u001a\u0004\u0018\u000108H\u0017J\b\u00109\u001a\u00020\u000fH\u0016J\b\u0010:\u001a\u00020\u000fH\u0016J\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcoil/drawable/ScaleDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Drawable$Callback;", "Landroid/graphics/drawable/Animatable;", "child", "scale", "Lcoil/size/Scale;", "(Landroid/graphics/drawable/Drawable;Lcoil/size/Scale;)V", "getChild", "()Landroid/graphics/drawable/Drawable;", "childDx", "", "childDy", "childScale", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getAlpha", "", "getColorFilter", "Landroid/graphics/ColorFilter;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "invalidateDrawable", "who", "isRunning", "", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "onLevelChange", "level", "onStateChange", "state", "", "scheduleDrawable", "what", "Ljava/lang/Runnable;", "when", "", "setAlpha", "alpha", "setColorFilter", "colorFilter", "setTint", "tintColor", "setTintBlendMode", "blendMode", "Landroid/graphics/BlendMode;", "setTintList", "tint", "Landroid/content/res/ColorStateList;", "setTintMode", "tintMode", "Landroid/graphics/PorterDuff$Mode;", "start", "stop", "unscheduleDrawable", "coil-gif_release"})
public final class ScaleDrawable
extends Drawable
implements Drawable.Callback,
Animatable {
    private float childDx;
    private float childDy;
    private float childScale;
    @NotNull
    private final Drawable child;
    private final Scale scale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$withSave = $this$withSave$iv;
            boolean bl = false;
            $this$withSave.translate(this.childDx, this.childDy);
            $this$withSave.scale(this.childScale, this.childScale);
            this.child.draw($this$withSave);
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }

    @RequiresApi(value=19)
    public int getAlpha() {
        return this.child.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.child.setAlpha(alpha);
    }

    public int getOpacity() {
        return this.child.getOpacity();
    }

    @RequiresApi(value=21)
    @Nullable
    public ColorFilter getColorFilter() {
        return this.child.getColorFilter();
    }

    @RequiresApi(value=21)
    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.child.setColorFilter(colorFilter);
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        int width = this.child.getIntrinsicWidth();
        int height = this.child.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            this.child.setBounds(bounds);
            this.childDx = 0.0f;
            this.childDy = 0.0f;
            this.childScale = 1.0f;
            return;
        }
        int targetWidth = bounds.width();
        int targetHeight = bounds.height();
        double multiplier = DecodeUtils.computeSizeMultiplier((int)width, (int)height, (int)targetWidth, (int)targetHeight, (Scale)this.scale);
        int left = MathKt.roundToInt((double)(((double)targetWidth - multiplier * (double)width) / (double)2));
        int top = MathKt.roundToInt((double)(((double)targetHeight - multiplier * (double)height) / (double)2));
        int right = left + width;
        int bottom = top + height;
        this.child.setBounds(left, top, right, bottom);
        this.childDx = bounds.left;
        this.childDy = bounds.top;
        this.childScale = (float)multiplier;
    }

    protected boolean onLevelChange(int level) {
        return this.child.setLevel(level);
    }

    protected boolean onStateChange(@NotNull int[] state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return this.child.setState(state);
    }

    public int getIntrinsicWidth() {
        return this.child.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.child.getIntrinsicHeight();
    }

    public void unscheduleDrawable(@NotNull Drawable who, @NotNull Runnable what) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.unscheduleSelf(what);
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        this.invalidateSelf();
    }

    public void scheduleDrawable(@NotNull Drawable who, @NotNull Runnable what, long when) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
        this.scheduleSelf(what, when);
    }

    @RequiresApi(value=21)
    public void setTint(int tintColor) {
        this.child.setTint(tintColor);
    }

    @RequiresApi(value=21)
    public void setTintList(@Nullable ColorStateList tint) {
        this.child.setTintList(tint);
    }

    @RequiresApi(value=21)
    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        this.child.setTintMode(tintMode);
    }

    @RequiresApi(value=29)
    public void setTintBlendMode(@Nullable BlendMode blendMode) {
        this.child.setTintBlendMode(blendMode);
    }

    public boolean isRunning() {
        return this.child instanceof Animatable ? ((Animatable)this.child).isRunning() : false;
    }

    public void start() {
        if (this.child instanceof Animatable) {
            ((Animatable)this.child).start();
        }
    }

    public void stop() {
        if (this.child instanceof Animatable) {
            ((Animatable)this.child).stop();
        }
    }

    @NotNull
    public final Drawable getChild() {
        return this.child;
    }

    @JvmOverloads
    public ScaleDrawable(@NotNull Drawable child, @NotNull Scale scale) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)scale, (String)"scale");
        this.child = child;
        this.scale = scale;
        this.childScale = 1.0f;
        this.child.setCallback((Drawable.Callback)this);
    }

    public /* synthetic */ ScaleDrawable(Drawable drawable, Scale scale, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            scale = Scale.FIT;
        }
        this(drawable, scale);
    }

    @JvmOverloads
    public ScaleDrawable(@NotNull Drawable child) {
        this(child, null, 2, null);
    }
}

