/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.xml;

import io.cloudevents.rw.CloudEventRWException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XMLUtils {
    private static final Pattern XML_PATTERN = Pattern.compile("^(application|text)\\/([a-zA-Z]+\\+)?xml(;.*)*$");
    private static final Pattern TEXT_PATTERN = Pattern.compile("^application\\/([a-zA-Z]+\\+)?(xml|json)(;.*)*$");

    private XMLUtils() {
    }

    static Document parseIntoDocument(byte[] data) throws CloudEventRWException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(data));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
    }

    static byte[] documentToBytes(Document doc) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer t = tFactory.newTransformer();
        DOMSource src = new DOMSource(doc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        t.transform(src, result);
        return os.toByteArray();
    }

    static int countOfChildElements(Element e) {
        if (e == null) {
            return 0;
        }
        int retVal = 0;
        NodeList nodeLIst = e.getChildNodes();
        for (int i = 0; i < nodeLIst.getLength(); ++i) {
            Node n = nodeLIst.item(i);
            if (n.getNodeType() != 1) continue;
            ++retVal;
        }
        return retVal;
    }

    static boolean isXmlContent(String contentType) {
        if (contentType == null) {
            return false;
        }
        Matcher m = XML_PATTERN.matcher(contentType);
        return m.matches();
    }

    static boolean isTextContent(String contentType) {
        if (contentType == null) {
            return false;
        }
        if (contentType.startsWith("text/")) {
            return true;
        }
        Matcher m = TEXT_PATTERN.matcher(contentType);
        return m.matches();
    }
}

