/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.runtime;

import io.cloudevents.sql.Function;
import io.cloudevents.sql.impl.functions.AbsFunction;
import io.cloudevents.sql.impl.functions.BoolFunction;
import io.cloudevents.sql.impl.functions.ConcatFunction;
import io.cloudevents.sql.impl.functions.ConcatWSFunction;
import io.cloudevents.sql.impl.functions.InfallibleOneArgumentFunction;
import io.cloudevents.sql.impl.functions.IntFunction;
import io.cloudevents.sql.impl.functions.IsBoolFunction;
import io.cloudevents.sql.impl.functions.IsIntFunction;
import io.cloudevents.sql.impl.functions.LeftFunction;
import io.cloudevents.sql.impl.functions.RightFunction;
import io.cloudevents.sql.impl.functions.StringFunction;
import io.cloudevents.sql.impl.functions.SubstringFunction;
import io.cloudevents.sql.impl.functions.SubstringWithLengthFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class FunctionTable {
    private final Map<String, Functions> functions = new HashMap<String, Functions>();

    public static FunctionTable getDefaultInstance() {
        return SingletonContainer.INSTANCE;
    }

    private FunctionTable(Stream<Function> functions) {
        functions.forEach(this::addFunction);
    }

    protected FunctionTable(FunctionTable functionTable) {
        this(functionTable.getFunctions());
    }

    protected Function resolve(String name, int args) throws IllegalStateException {
        Functions fns = this.functions.get(name);
        if (fns == null) {
            throw new IllegalStateException("No function named '" + name + "' found. Available function names: " + this.functions.keySet());
        }
        return fns.resolve(args);
    }

    protected void addFunction(Function function) throws IllegalArgumentException {
        Functions fns = this.functions.computeIfAbsent(function.name(), v -> new Functions());
        fns.addFunction(function);
    }

    private Stream<Function> getFunctions() {
        return this.functions.values().stream().flatMap(rec$ -> ((Functions)rec$).getFunctions());
    }

    private static class Functions {
        private final Map<Integer, Function> fixedArgsNumberFunctions = new HashMap<Integer, Function>();
        private Function variadicFunction;

        private Functions() {
        }

        public void addFunction(Function function) {
            if (function.isVariadic()) {
                if (this.fixedArgsNumberFunctions.keySet().stream().max(Integer::compareTo).map(maxArity -> maxArity >= function.arity()).orElse(false).booleanValue()) {
                    throw new IllegalArgumentException("You're trying to add a variadic function, but one function with the same name and arity greater or equal is already defined: " + function.name());
                }
                if (this.variadicFunction != null) {
                    throw new IllegalArgumentException("You're trying to add a variadic function, but one is already defined for this function name: " + function.name());
                }
                this.variadicFunction = function;
            } else {
                Function old = this.fixedArgsNumberFunctions.put(function.arity(), function);
                if (old != null) {
                    throw new IllegalArgumentException("You're trying to add a function, but one with the same arity is already defined: " + function.name() + " with arity " + function.arity());
                }
            }
        }

        public Function resolve(int args) {
            Function fn = this.fixedArgsNumberFunctions.get(args);
            if (fn != null) {
                return fn;
            }
            if (this.variadicFunction == null) {
                throw this.createMissingFunctionException(args);
            }
            if (this.variadicFunction.arity() > args) {
                throw this.createMissingFunctionException(args);
            }
            return this.variadicFunction;
        }

        private RuntimeException createMissingFunctionException(int args) {
            return new IllegalStateException("No functions with arity " + args + " found. Available functions: " + this.fixedArgsNumberFunctions.values() + (this.variadicFunction != null ? " and variadic " + this.variadicFunction : ""));
        }

        private Stream<Function> getFunctions() {
            if (this.variadicFunction == null) {
                return this.fixedArgsNumberFunctions.values().stream();
            }
            return Stream.concat(this.fixedArgsNumberFunctions.values().stream(), Stream.of(this.variadicFunction));
        }
    }

    private static class SingletonContainer {
        private static final FunctionTable INSTANCE = new FunctionTable(Stream.of(new AbsFunction(), new IntFunction(), new BoolFunction(), new StringFunction(), new IsBoolFunction(), new IsIntFunction(), new InfallibleOneArgumentFunction<String, Integer>("LENGTH", String.class, Integer.class, String::length), new ConcatFunction(), new ConcatWSFunction(), new InfallibleOneArgumentFunction<String, String>("LOWER", String.class, String.class, String::toLowerCase), new InfallibleOneArgumentFunction<String, String>("UPPER", String.class, String.class, String::toUpperCase), new InfallibleOneArgumentFunction<String, String>("TRIM", String.class, String.class, String::trim), new LeftFunction(), new RightFunction(), new SubstringFunction(), new SubstringWithLengthFunction()));

        private SingletonContainer() {
        }
    }
}

