/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.runtime;

import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.Result;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EvaluationResult
implements Result {
    private final Object value;
    private final List<EvaluationException> exceptions;

    public EvaluationResult(Object value, List<EvaluationException> exceptions) {
        this.value = value;
        this.exceptions = exceptions == null ? Collections.emptyList() : Collections.unmodifiableList(exceptions);
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isFailed() {
        return !this.exceptions.isEmpty();
    }

    @Override
    public Collection<EvaluationException> causes() {
        return this.exceptions != null ? this.exceptions : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationResult that = (EvaluationResult)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.exceptions, that.exceptions);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.exceptions);
    }

    public String toString() {
        return "EvaluationResult{  value=" + this.value + "\n  , exceptions=" + this.exceptions + "\n" + '}';
    }
}

