/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.messaging;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

class MessageBuilderMessageWriter
implements CloudEventWriter<Message<byte[]>>,
MessageWriter<MessageBuilderMessageWriter, Message<byte[]>> {
    private Map<String, Object> headers = new HashMap<String, Object>();

    public MessageBuilderMessageWriter(Map<String, Object> headers) {
        this.headers.putAll(headers);
    }

    public MessageBuilderMessageWriter() {
    }

    public Message<byte[]> setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.headers.put("ce-datacontenttype", format.serializedContentType());
        return MessageBuilder.withPayload((Object)value).copyHeaders(this.headers).build();
    }

    public Message<byte[]> end(CloudEventData value) throws CloudEventRWException {
        return MessageBuilder.withPayload((Object)(value == null ? new byte[]{} : value.toBytes())).copyHeaders(this.headers).build();
    }

    public Message<byte[]> end() {
        return MessageBuilder.withPayload((Object)new byte[0]).copyHeaders(this.headers).build();
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        this.headers.put("ce-" + name, value);
        return this;
    }

    public MessageBuilderMessageWriter create(SpecVersion version) {
        this.headers.put("ce-specversion", version.toString());
        return this;
    }
}

