/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.kafka.impl.KafkaHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

abstract class BaseKafkaMessageWriterImpl<R>
implements MessageWriter<CloudEventWriter<R>, R>,
CloudEventWriter<R> {
    final Headers headers;
    byte[] value;

    public BaseKafkaMessageWriterImpl(Headers headers) {
        this.headers = headers;
    }

    public BaseKafkaMessageWriterImpl<R> withContextAttribute(String name, String value) throws CloudEventRWException {
        String headerName = KafkaHeaders.ATTRIBUTES_TO_HEADERS.get(name);
        if (headerName == null) {
            headerName = "ce_" + name;
        }
        this.headers.add((Header)new RecordHeader(headerName, value.getBytes(StandardCharsets.UTF_8)));
        return this;
    }

    public R end(CloudEventData value) throws CloudEventRWException {
        this.value = value.toBytes();
        return (R)this.end();
    }

    public R setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.headers.add((Header)new RecordHeader("content-type", format.serializedContentType().getBytes(StandardCharsets.UTF_8)));
        this.value = value;
        return (R)this.end();
    }
}

