/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.kafka.impl.KafkaSerializerMessageWriterImpl;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class CloudEventSerializer
implements Serializer<CloudEvent> {
    public static final String ENCODING_CONFIG = "cloudevents.serializer.encoding";
    public static final String EVENT_FORMAT_CONFIG = "cloudevents.serializer.event_format";
    private Encoding encoding = Encoding.BINARY;
    private EventFormat format = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (isKey) {
            throw new IllegalArgumentException("Cannot use CloudEventSerializer as key serializer");
        }
        Object encodingConfig = configs.get(ENCODING_CONFIG);
        if (encodingConfig instanceof String) {
            this.encoding = Encoding.valueOf((String)((String)encodingConfig));
        } else if (encodingConfig instanceof Encoding) {
            this.encoding = (Encoding)encodingConfig;
        } else if (encodingConfig != null) {
            throw new IllegalArgumentException("cloudevents.serializer.encoding can be of type String or " + Encoding.class.getCanonicalName());
        }
        if (this.encoding == Encoding.UNKNOWN) {
            throw new IllegalArgumentException("cloudevents.serializer.encoding cannot be " + Encoding.UNKNOWN);
        }
        if (this.encoding == Encoding.STRUCTURED) {
            Object eventFormatConfig = configs.get(EVENT_FORMAT_CONFIG);
            if (eventFormatConfig instanceof String) {
                this.format = EventFormatProvider.getInstance().resolveFormat((String)eventFormatConfig);
                if (this.format == null) {
                    throw new IllegalArgumentException("cloudevents.serializer.event_format cannot be resolved with " + eventFormatConfig);
                }
            } else if (eventFormatConfig instanceof EventFormat) {
                this.format = (EventFormat)eventFormatConfig;
            } else {
                throw new IllegalArgumentException("cloudevents.serializer.event_format cannot be null and can be of type String or " + EventFormat.class.getCanonicalName());
            }
        }
    }

    public byte[] serialize(String topic, CloudEvent data) {
        throw new UnsupportedOperationException("CloudEventSerializer supports only the signature serialize(String, Headers, CloudEvent)");
    }

    public byte[] serialize(String topic, Headers headers, CloudEvent data) {
        if (this.encoding == Encoding.STRUCTURED) {
            return (byte[])new KafkaSerializerMessageWriterImpl(headers).writeStructured(data, this.format);
        }
        return (byte[])new KafkaSerializerMessageWriterImpl(headers).writeBinary(data);
    }
}

