/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v02.kafka;

import io.cloudevents.v02.ContextAttributes;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;

public class ExtensionMapper {
    private static final List<String> RESERVED_HEADERS = ContextAttributes.VALUES.stream().map(attribute -> "ce_" + attribute).collect(Collectors.toList());
    private static final Deserializer<String> DESERIALIZER;
    private static final String NULL_ARG;

    private ExtensionMapper() {
    }

    public static Map<String, String> map(Map<String, Object> headers) {
        Objects.requireNonNull(headers);
        return headers.entrySet().stream().filter(header -> null != header.getValue()).map(header -> new AbstractMap.SimpleEntry(((String)header.getKey()).toLowerCase(Locale.US), header.getValue())).filter(header -> !RESERVED_HEADERS.contains(header.getKey())).map(header -> new AbstractMap.SimpleEntry(header.getKey(), (byte[])header.getValue())).map(header -> {
            String key = (String)header.getKey();
            String val = (String)DESERIALIZER.deserialize(NULL_ARG, (byte[])header.getValue());
            return new AbstractMap.SimpleEntry<String, String>(key, val);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static {
        RESERVED_HEADERS.add("content-type");
        DESERIALIZER = Serdes.String().deserializer();
        NULL_ARG = null;
    }
}

