/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.restful.ws.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.restful.ws.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;

public final class RestfulWSMessageWriter
implements CloudEventWriter<Void>,
MessageWriter<RestfulWSMessageWriter, Void> {
    private final MultivaluedMap<String, Object> httpHeaders;
    private final OutputStream entityStream;

    public RestfulWSMessageWriter(MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        this.httpHeaders = httpHeaders;
        this.entityStream = entityStream;
        this.httpHeaders.remove((Object)"Content-Type");
    }

    public RestfulWSMessageWriter create(SpecVersion version) {
        this.httpHeaders.add((Object)CloudEventsHeaders.SPEC_VERSION, (Object)version.toString());
        return this;
    }

    public void setAttribute(String name, String value) throws CloudEventRWException {
        this.httpHeaders.add((Object)CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name), (Object)value);
    }

    public void setExtension(String name, String value) throws CloudEventRWException {
        this.httpHeaders.add((Object)("ce-" + name), (Object)value);
    }

    public Void end(byte[] value) throws CloudEventRWException {
        try {
            this.entityStream.write(value);
        }
        catch (IOException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
        return this.end();
    }

    public Void end() {
        try {
            this.entityStream.flush();
        }
        catch (IOException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
        return null;
    }

    public Void setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.httpHeaders.add((Object)"Content-Type", (Object)format.serializedContentType());
        this.end(value);
        return null;
    }
}

