/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.message.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.Encoding;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.provider.EventFormatProvider;
import io.cloudevents.rw.CloudEventRWException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MessageUtils {
    public static MessageReader parseStructuredOrBinaryMessage(Supplier<String> contentTypeHeaderReader, Function<EventFormat, MessageReader> structuredMessageFactory, Supplier<String> specVersionHeaderReader, Function<SpecVersion, MessageReader> binaryMessageFactory) throws CloudEventRWException {
        String specVersionUnparsed;
        String ct = contentTypeHeaderReader.get();
        if (ct != null) {
            EventFormat format = EventFormatProvider.getInstance().resolveFormat(ct);
            if (format != null) {
                return structuredMessageFactory.apply(format);
            }
            if (ct.startsWith("application/cloudevents")) {
                throw CloudEventRWException.newUnknownEncodingException();
            }
        }
        if ((specVersionUnparsed = specVersionHeaderReader.get()) != null) {
            return binaryMessageFactory.apply(SpecVersion.parse((String)specVersionUnparsed));
        }
        throw CloudEventRWException.newUnknownEncodingException();
    }

    public static <V> Map<String, V> generateAttributesToHeadersMapping(Function<String, V> headerNameMapping) {
        return Stream.concat(Stream.concat(SpecVersion.V1.getMandatoryAttributes().stream(), SpecVersion.V1.getOptionalAttributes().stream()), Stream.concat(SpecVersion.V03.getMandatoryAttributes().stream(), SpecVersion.V03.getOptionalAttributes().stream())).distinct().collect(Collectors.toMap(Function.identity(), headerNameMapping));
    }

    public static IllegalStateException generateWrongEncoding(Encoding expected, Encoding actual) {
        return new IllegalStateException("Cannot visit message as " + (Object)((Object)expected) + " because the actual encoding is " + (Object)((Object)actual));
    }
}

