/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.core.v1.CloudEventBuilder;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.types.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;

class V03ToV1AttributesConverter
implements CloudEventContextWriter {
    private final CloudEventBuilder builder;

    V03ToV1AttributesConverter(CloudEventBuilder builder) {
        this.builder = builder;
    }

    public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        switch (name) {
            case "id": {
                this.builder.withId(value);
                return this;
            }
            case "source": {
                try {
                    this.builder.withSource(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"source", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "type": {
                this.builder.withType(value);
                return this;
            }
            case "datacontenttype": {
                this.builder.withDataContentType(value);
                return this;
            }
            case "schemaurl": {
                try {
                    this.builder.withDataSchema(new URI(value));
                }
                catch (URISyntaxException e) {
                    throw CloudEventRWException.newInvalidAttributeValue((String)"schemaurl", (Object)value, (Throwable)e);
                }
                return this;
            }
            case "subject": {
                this.builder.withSubject(value);
                return this;
            }
            case "time": {
                this.builder.withTime(Time.parseTime((String)"time", (String)value));
                return this;
            }
        }
        this.builder.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
        switch (name) {
            case "source": {
                this.builder.withSource(value);
                return this;
            }
            case "schemaurl": {
                this.builder.withDataSchema(value);
                return this;
            }
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": 
            case "time": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, URI.class);
            }
        }
        this.builder.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
        switch (name) {
            case "time": {
                this.builder.withTime(value);
                return this;
            }
            case "source": 
            case "schemaurl": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, OffsetDateTime.class);
            }
        }
        this.builder.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
        switch (name) {
            case "time": 
            case "source": 
            case "schemaurl": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, Number.class);
            }
        }
        this.builder.withExtension(name, value);
        return this;
    }

    public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
        switch (name) {
            case "time": 
            case "source": 
            case "schemaurl": 
            case "id": 
            case "type": 
            case "datacontenttype": 
            case "subject": {
                throw CloudEventRWException.newInvalidAttributeType((String)name, Boolean.class);
            }
        }
        this.builder.withExtension(name, value);
        return this;
    }
}

