/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.builder;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.Extension;
import io.cloudevents.SpecVersion;
import io.cloudevents.rw.CloudEventWriter;
import java.net.URI;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public interface CloudEventBuilder
extends CloudEventWriter<CloudEvent> {
    public CloudEventBuilder withId(String var1);

    public CloudEventBuilder withSource(URI var1);

    public CloudEventBuilder withType(String var1);

    public CloudEventBuilder withDataSchema(URI var1);

    public CloudEventBuilder withDataContentType(String var1);

    public CloudEventBuilder withSubject(String var1);

    public CloudEventBuilder withTime(OffsetDateTime var1);

    public CloudEventBuilder withData(byte[] var1);

    public CloudEventBuilder withData(String var1, byte[] var2);

    public CloudEventBuilder withData(String var1, URI var2, byte[] var3);

    public CloudEventBuilder withData(CloudEventData var1);

    public CloudEventBuilder withData(String var1, CloudEventData var2);

    public CloudEventBuilder withData(String var1, URI var2, CloudEventData var3);

    public CloudEventBuilder withExtension(@Nonnull String var1, @Nonnull String var2);

    public CloudEventBuilder withExtension(@Nonnull String var1, @Nonnull Number var2);

    public CloudEventBuilder withExtension(@Nonnull String var1, @Nonnull Boolean var2);

    public CloudEventBuilder withExtension(@Nonnull Extension var1);

    public CloudEventBuilder withoutExtension(@Nonnull String var1);

    public CloudEventBuilder withoutExtension(@Nonnull Extension var1);

    public CloudEvent build() throws IllegalStateException;

    public CloudEventBuilder newBuilder();

    public static io.cloudevents.core.v1.CloudEventBuilder v1() {
        return new io.cloudevents.core.v1.CloudEventBuilder();
    }

    public static io.cloudevents.core.v1.CloudEventBuilder v1(@Nonnull CloudEvent event) {
        return new io.cloudevents.core.v1.CloudEventBuilder(event);
    }

    public static io.cloudevents.core.v03.CloudEventBuilder v03() {
        return new io.cloudevents.core.v03.CloudEventBuilder();
    }

    public static io.cloudevents.core.v03.CloudEventBuilder v03(@Nonnull CloudEvent event) {
        return new io.cloudevents.core.v03.CloudEventBuilder(event);
    }

    public static CloudEventBuilder fromSpecVersion(@Nonnull SpecVersion version) {
        switch (version) {
            case V1: {
                return CloudEventBuilder.v1();
            }
            case V03: {
                return CloudEventBuilder.v03();
            }
        }
        throw new IllegalStateException("The provided spec version doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }

    public static CloudEventBuilder from(@Nonnull CloudEvent event) {
        switch (event.getSpecVersion()) {
            case V1: {
                return CloudEventBuilder.v1(event);
            }
            case V03: {
                return CloudEventBuilder.v03(event);
            }
        }
        throw new IllegalStateException("The provided spec version doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }

    public static CloudEventBuilder fromContext(@Nonnull CloudEventContext context) {
        switch (context.getSpecVersion()) {
            case V1: {
                return new io.cloudevents.core.v1.CloudEventBuilder(context);
            }
            case V03: {
                return new io.cloudevents.core.v03.CloudEventBuilder(context);
            }
        }
        throw new IllegalStateException("The provided spec version doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }
}

