/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.rw;

public class CloudEventRWException
extends RuntimeException {
    private final CloudEventRWExceptionKind kind;

    public CloudEventRWException(CloudEventRWExceptionKind kind, Throwable cause) {
        super(cause);
        this.kind = kind;
    }

    public CloudEventRWException(CloudEventRWExceptionKind kind, String message) {
        super(message);
        this.kind = kind;
    }

    public CloudEventRWException(CloudEventRWExceptionKind kind, String message, Throwable cause) {
        super(message, cause);
        this.kind = kind;
    }

    public CloudEventRWExceptionKind getKind() {
        return this.kind;
    }

    public static CloudEventRWException newInvalidSpecVersion(String specVersion) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_TYPE, "Invalid specversion: " + specVersion);
    }

    public static CloudEventRWException newInvalidAttributeName(String attributeName) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_NAME, "Invalid attribute: " + attributeName);
    }

    public static CloudEventRWException newInvalidAttributeType(String attributeName, Class<?> clazz) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_TYPE, "Invalid attribute type for \"" + attributeName + "\": " + clazz.getCanonicalName());
    }

    public static CloudEventRWException newInvalidAttributeValue(String attributeName, Object value, Throwable cause) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_ATTRIBUTE_VALUE, "Invalid attribute value for \"" + attributeName + "\": " + value, cause);
    }

    public static CloudEventRWException newInvalidExtensionType(String extensionName, Class<?> clazz) {
        return new CloudEventRWException(CloudEventRWExceptionKind.INVALID_EXTENSION_TYPE, "Invalid extension type for \"" + extensionName + "\": " + clazz.getCanonicalName());
    }

    public static CloudEventRWException newOther(Throwable cause) {
        return new CloudEventRWException(CloudEventRWExceptionKind.OTHER, cause);
    }

    public static enum CloudEventRWExceptionKind {
        INVALID_SPEC_VERSION,
        INVALID_ATTRIBUTE_NAME,
        INVALID_ATTRIBUTE_TYPE,
        INVALID_ATTRIBUTE_VALUE,
        INVALID_EXTENSION_TYPE,
        OTHER;

    }
}

