/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1;

import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.v1.Accessor;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;

public class CloudEventBuilder<T>
implements EventBuilder<T, AttributesImpl> {
    private static Validator VALIDATOR;
    public static final String SPEC_VERSION = "1.0";
    private static final String MESSAGE_SEPARATOR = ", ";
    private static final String MESSAGE = "'%s' %s";
    private static final String ERR_MESSAGE = "invalid payload: %s";
    private String id;
    private URI source;
    private String type;
    private String datacontenttype;
    private URI dataschema;
    private String subject;
    private ZonedDateTime time;
    private T data;
    private final Set<ExtensionFormat> extensions = new HashSet<ExtensionFormat>();
    private Validator validator;

    private CloudEventBuilder() {
    }

    private static Validator getValidator() {
        if (null == VALIDATOR) {
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return VALIDATOR;
    }

    public static <T> CloudEventBuilder<T> builder() {
        return new CloudEventBuilder<T>();
    }

    public static <T> CloudEventBuilder<T> builder(CloudEvent<AttributesImpl, T> base) {
        Objects.requireNonNull(base);
        CloudEventBuilder<T> result = new CloudEventBuilder<T>();
        AttributesImpl attributes = base.getAttributes();
        result.withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getDataschema().ifPresent(result::withDataschema);
        attributes.getDatacontenttype().ifPresent(result::withDataContentType);
        attributes.getSubject().ifPresent(result::withSubject);
        attributes.getTime().ifPresent(result::withTime);
        Accessor.extensionsOf(base).forEach(result::withExtension);
        base.getData().ifPresent(result::withData);
        return result;
    }

    @Override
    public CloudEvent<AttributesImpl, T> build(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        CloudEventBuilder<T> builder = CloudEventBuilder.builder().withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(builder::withTime);
        attributes.getDataschema().ifPresent(builder::withDataschema);
        attributes.getDatacontenttype().ifPresent(builder::withDataContentType);
        attributes.getSubject().ifPresent(builder::withSubject);
        extensions.forEach(builder::withExtension);
        return builder.withData(data).withValidator(this.validator).build();
    }

    public CloudEventImpl<T> build() {
        AttributesImpl attributes = new AttributesImpl(this.id, this.source, SPEC_VERSION, this.type, this.datacontenttype, this.dataschema, this.subject, this.time);
        CloudEventImpl<T> cloudEvent = new CloudEventImpl<T>(attributes, this.data, this.extensions);
        if (this.data instanceof byte[]) {
            cloudEvent.setDataBase64((byte[])this.data);
        }
        if (this.validator == null) {
            this.validator = CloudEventBuilder.getValidator();
        }
        Set violations = this.validator.validate(cloudEvent, new Class[0]);
        violations.addAll(this.validator.validate((Object)cloudEvent.getAttributes(), new Class[0]));
        String errs = violations.stream().map(v -> String.format(MESSAGE, v.getPropertyPath(), v.getMessage())).collect(Collectors.joining(MESSAGE_SEPARATOR));
        Optional.ofNullable("".equals(errs) ? null : errs).ifPresent(e -> {
            throw new IllegalStateException(String.format(ERR_MESSAGE, e));
        });
        return cloudEvent;
    }

    public CloudEventBuilder<T> withId(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder<T> withSource(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> withType(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder<T> withDataschema(URI dataschema) {
        this.dataschema = dataschema;
        return this;
    }

    public CloudEventBuilder<T> withDataContentType(String datacontenttype) {
        this.datacontenttype = datacontenttype;
        return this;
    }

    public CloudEventBuilder<T> withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public CloudEventBuilder<T> withTime(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder<T> withData(T data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder<T> withExtension(ExtensionFormat extension) {
        this.extensions.add(extension);
        return this;
    }

    public CloudEventBuilder<T> withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }
}

