/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.extensions.InMemoryFormat;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class CloudEventImpl<T>
implements CloudEvent<AttributesImpl, T> {
    public static final String EVENT_DATA_FIELD = "data";
    public static final String EVENT_DATA_BASE64_FILED = "data_base64";
    @JsonIgnore
    @NotNull
    private final AttributesImpl attributes;
    @JsonIgnore
    private final T data;
    @JsonIgnore
    private byte[] dataBase64;
    @NotNull
    private final Map<String, Object> extensions;
    private final Set<ExtensionFormat> extensionsFormats;

    CloudEventImpl(AttributesImpl attributes, T data, Set<ExtensionFormat> extensions) {
        this.attributes = attributes;
        this.data = data;
        this.extensions = extensions.stream().map(ExtensionFormat::memory).collect(Collectors.toMap(InMemoryFormat::getKey, InMemoryFormat::getValue));
        this.extensionsFormats = extensions;
    }

    Set<ExtensionFormat> getExtensionsFormats() {
        return this.extensionsFormats;
    }

    void setDataBase64(byte[] data) {
        this.dataBase64 = data;
    }

    @Override
    @JsonUnwrapped
    public AttributesImpl getAttributes() {
        return this.attributes;
    }

    @Override
    public Optional<T> getData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getExtensions() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.extensions);
        if (null == this.dataBase64) {
            if (null != this.data) {
                result.put(EVENT_DATA_FIELD, this.data);
            }
        } else {
            result.put(EVENT_DATA_BASE64_FILED, this.dataBase64);
        }
        return Collections.unmodifiableMap(result);
    }

    @JsonAnySetter
    void addExtension(String name, Object value) {
        this.extensions.put(name, value);
    }

    @JsonCreator
    public static <T> CloudEventImpl<T> build(@JsonProperty(value="id") String id, @JsonProperty(value="source") URI source, @JsonProperty(value="specversion") String specversion, @JsonProperty(value="type") String type, @JsonProperty(value="datacontenttype") String datacontenttype, @JsonProperty(value="dataschema") URI dataschema, @JsonProperty(value="subject") String subject, @JsonProperty(value="time") ZonedDateTime time, @JsonProperty(value="data") @JsonAlias(value={"data_base64"}) T data) {
        return CloudEventBuilder.builder().withId(id).withSource(source).withType(type).withTime(time).withDataschema(dataschema).withDataContentType(datacontenttype).withData(data).withSubject(subject).build();
    }
}

