/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.format;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.format.builder.HeadersStep;
import io.cloudevents.format.builder.PayloadStep;
import io.cloudevents.format.builder.UnmarshalStep;
import io.cloudevents.fun.AttributeUnmarshaller;
import io.cloudevents.fun.BinaryFormatAttributeMapper;
import io.cloudevents.fun.DataUnmarshaller;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.fun.ExtensionUmarshaller;
import io.cloudevents.fun.FormatExtensionMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class BinaryUnmarshaller {
    private BinaryUnmarshaller() {
    }

    public static <A extends Attributes, T, P> AttributeMapStep<A, T, P> builder() {
        return new Builder();
    }

    private static final class Builder<A extends Attributes, T, P>
    implements AttributeMapStep<A, T, P>,
    AttributeUmarshallStep<A, T, P>,
    DataUnmarshallerStep<A, T, P>,
    ExtensionsMapStep<A, T, P>,
    ExtensionsStep<A, T, P>,
    BuilderStep<A, T, P>,
    HeadersStep<A, T, P>,
    PayloadStep<A, T, P>,
    UnmarshalStep<A, T> {
        private BinaryFormatAttributeMapper attributeMapper;
        private AttributeUnmarshaller<A> attributeUnmarshaller;
        private Map<String, DataUnmarshaller<P, T, A>> dataUnmarshallers = new HashMap<String, DataUnmarshaller<P, T, A>>();
        private FormatExtensionMapper extensionMapper;
        private Set<ExtensionUmarshaller> extensionUnmarshallers = new HashSet<ExtensionUmarshaller>();
        private EventBuilder<T, A> eventBuilder;
        private Supplier<Map<String, Object>> headersSupplier;
        private Supplier<P> payloadSupplier;

        private Builder() {
        }

        @Override
        public AttributeUmarshallStep<A, T, P> map(BinaryFormatAttributeMapper mapper) {
            this.attributeMapper = mapper;
            return this;
        }

        @Override
        public DataUnmarshallerStep<A, T, P> map(AttributeUnmarshaller<A> unmarshaller) {
            this.attributeUnmarshaller = unmarshaller;
            return this;
        }

        @Override
        public DataUnmarshallerStep<A, T, P> map(String mime, DataUnmarshaller<P, T, A> unmarshaller) {
            this.dataUnmarshallers.put(mime, unmarshaller);
            return this;
        }

        @Override
        public Builder<A, T, P> next() {
            return this;
        }

        @Override
        public ExtensionsStep<A, T, P> map(FormatExtensionMapper mapper) {
            this.extensionMapper = mapper;
            return this;
        }

        @Override
        public ExtensionsStep<A, T, P> map(ExtensionUmarshaller unmarshaller) {
            this.extensionUnmarshallers.add(unmarshaller);
            return this;
        }

        @Override
        public HeadersStep<A, T, P> builder(EventBuilder<T, A> builder) {
            this.eventBuilder = builder;
            return this;
        }

        @Override
        public PayloadStep<A, T, P> withHeaders(Supplier<Map<String, Object>> headers) {
            this.headersSupplier = headers;
            return this;
        }

        @Override
        public UnmarshalStep<A, T> withPayload(Supplier<P> payload) {
            this.payloadSupplier = payload;
            return this;
        }

        @Override
        public CloudEvent<A, T> unmarshal() {
            Map<String, Object> headers = this.headersSupplier.get();
            Object payload = this.payloadSupplier.get();
            Map<String, String> attributesMap = this.attributeMapper.map(headers);
            Object attributes = this.attributeUnmarshaller.unmarshal(attributesMap);
            Object data = attributes.getMediaType().map((? super T mime) -> this.dataUnmarshallers.get(mime)).filter(un -> null != un).map((? super T unmarshaller) -> unmarshaller.unmarshal(payload, attributes)).orElse(null);
            Map<String, String> extensionsMap = this.extensionMapper.map(headers);
            List<ExtensionFormat> extensions = this.extensionUnmarshallers.stream().map((? super T unmarshaller) -> unmarshaller.unmarshal(extensionsMap)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return this.eventBuilder.build(data, attributes, extensions);
        }
    }

    public static interface BuilderStep<A extends Attributes, T, P> {
        public HeadersStep<A, T, P> builder(EventBuilder<T, A> var1);
    }

    public static interface ExtensionsStep<A extends Attributes, T, P> {
        public ExtensionsStep<A, T, P> map(ExtensionUmarshaller var1);

        public BuilderStep<A, T, P> next();
    }

    public static interface ExtensionsStepBegin<A extends Attributes, T, P> {
        public ExtensionsStep<A, T, P> beginExtensions();
    }

    public static interface ExtensionsMapStep<A extends Attributes, T, P> {
        public ExtensionsStep<A, T, P> map(FormatExtensionMapper var1);
    }

    public static interface DataUnmarshallerStep<A extends Attributes, T, P> {
        public DataUnmarshallerStep<A, T, P> map(String var1, DataUnmarshaller<P, T, A> var2);

        public ExtensionsMapStep<A, T, P> next();
    }

    public static interface AttributeUmarshallStep<A extends Attributes, T, P> {
        public DataUnmarshallerStep<A, T, P> map(AttributeUnmarshaller<A> var1);
    }

    public static interface AttributeMapStep<A extends Attributes, T, P> {
        public AttributeUmarshallStep<A, T, P> map(BinaryFormatAttributeMapper var1);
    }
}

