/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.amqp.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;

public final class ProtonAmqpBinaryMessageReader
extends BaseGenericBinaryMessageReaderImpl<String, Object> {
    private final String contentType;
    private final ApplicationProperties applicationProperties;

    public ProtonAmqpBinaryMessageReader(SpecVersion version, ApplicationProperties applicationProperties, String contentType, byte[] payload) {
        super(version, payload != null && payload.length > 0 ? BytesCloudEventData.wrap((byte[])payload) : null);
        this.contentType = contentType;
        this.applicationProperties = Objects.requireNonNull(applicationProperties);
    }

    protected boolean isContentTypeHeader(String key) {
        return key.equals("content-type");
    }

    protected boolean isCloudEventsHeader(String key) {
        int prefixLength = "cloudEvents:".length();
        return key.length() > prefixLength && key.startsWith("cloudEvents:");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("cloudEvents:".length());
    }

    protected void forEachHeader(BiConsumer<String, Object> fn) {
        if (this.contentType != null) {
            fn.accept("content-type", this.contentType);
        }
        this.applicationProperties.getValue().forEach((k, v) -> {
            if (k != null && v != null) {
                fn.accept((String)k, v);
            }
        });
    }

    protected String toCloudEventsValue(Object value) {
        return value.toString();
    }
}

