/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.amqp.impl;

import io.cloudevents.core.message.impl.MessageUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;

public final class AmqpConstants {
    public static final String CE_PREFIX = "cloudEvents:";
    public static final String PROPERTY_CONTENT_TYPE = "content-type";
    public static final Map<String, String> ATTRIBUTES_TO_PROPERTYNAMES = MessageUtils.generateAttributesToHeadersMapping(CEA -> {
        if (CEA.equals("datacontenttype")) {
            return PROPERTY_CONTENT_TYPE;
        }
        return CE_PREFIX + CEA;
    });
    public static final String APP_PROPERTY_SPEC_VERSION = ATTRIBUTES_TO_PROPERTYNAMES.get("specversion");

    private AmqpConstants() {
    }

    public static <T> T getApplicationProperty(ApplicationProperties props, String name, Class<T> type) {
        if (props == null) {
            return null;
        }
        Object value = props.getValue().get(name);
        if (type.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public static byte[] getPayloadAsByteArray(Section payload) {
        if (payload == null) {
            return null;
        }
        if (payload instanceof Data) {
            Data body = (Data)payload;
            return body.getValue().getArray();
        }
        if (payload instanceof AmqpValue) {
            AmqpValue body = (AmqpValue)payload;
            if (body.getValue() instanceof byte[]) {
                return (byte[])body.getValue();
            }
            if (body.getValue() instanceof String && ((String)body.getValue()).length() > 0) {
                return ((String)body.getValue()).getBytes(StandardCharsets.UTF_8);
            }
        }
        return null;
    }
}

