/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.amqp.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.amqp.impl.AmqpConstants;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventExtensionsWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.util.HashMap;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public final class ProtonAmqpMessageWriter<R>
implements MessageWriter<CloudEventWriter<Message>, Message>,
CloudEventWriter<Message> {
    private ApplicationProperties applicationProperties;
    private Message message = Message.Factory.create();

    public CloudEventAttributesWriter withAttribute(String name, String value) throws CloudEventRWException {
        if (name.equals("datacontenttype")) {
            this.message.setContentType(value);
        } else {
            if (this.applicationProperties == null) {
                throw new IllegalStateException("This Writer is not initialized");
            }
            this.applicationProperties.getValue().put(AmqpConstants.ATTRIBUTES_TO_PROPERTYNAMES.get(name), value);
        }
        return null;
    }

    public CloudEventExtensionsWriter withExtension(String name, String value) throws CloudEventRWException {
        if (this.applicationProperties == null) {
            throw new IllegalStateException("This Writer is not initialized");
        }
        this.applicationProperties.getValue().put(name, value);
        return null;
    }

    public ProtonAmqpMessageWriter<R> create(SpecVersion version) {
        if (this.applicationProperties == null) {
            this.applicationProperties = new ApplicationProperties(new HashMap());
        }
        this.applicationProperties.getValue().put(AmqpConstants.APP_PROPERTY_SPEC_VERSION, version.toString());
        return this;
    }

    public Message setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.message.setContentType(format.serializedContentType());
        this.message.setBody((Section)new Data(new Binary(value)));
        return this.message;
    }

    public Message end(CloudEventData data) throws CloudEventRWException {
        this.message.setBody((Section)new Data(new Binary(data.toBytes())));
        this.message.setApplicationProperties(this.applicationProperties);
        return this.message;
    }

    public Message end() {
        this.message.setBody(null);
        this.message.setApplicationProperties(this.applicationProperties);
        return this.message;
    }
}

