/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.amqp;

import io.cloudevents.SpecVersion;
import io.cloudevents.amqp.impl.AmqpConstants;
import io.cloudevents.amqp.impl.ProtonAmqpBinaryMessageReader;
import io.cloudevents.amqp.impl.ProtonAmqpMessageWriter;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.rw.CloudEventWriter;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;

@ParametersAreNonnullByDefault
public final class ProtonAmqpMessageFactory {
    private ProtonAmqpMessageFactory() {
    }

    public static MessageReader createReader(Message message) {
        byte[] payload = AmqpConstants.getPayloadAsByteArray(message.getBody());
        return ProtonAmqpMessageFactory.createReader(message.getContentType(), message.getApplicationProperties(), payload);
    }

    public static MessageReader createReader(String contentType, byte[] payload) {
        return ProtonAmqpMessageFactory.createReader(contentType, null, payload);
    }

    public static MessageWriter<CloudEventWriter<Message>, Message> createWriter() {
        return new ProtonAmqpMessageWriter();
    }

    public static MessageReader createReader(String contentType, ApplicationProperties props, byte[] payload) {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> contentType, format -> new GenericStructuredMessageReader(format, payload), () -> AmqpConstants.getApplicationProperty(props, AmqpConstants.APP_PROPERTY_SPEC_VERSION, String.class), sv -> new ProtonAmqpBinaryMessageReader((SpecVersion)sv, props, contentType, payload));
    }
}

