/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.clientcore.linting.extensions.revapi.transforms.PrefixMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.revapi.AnalysisContext;

final class RevApiUtils {
    private static final String CONFIGURATION_ERROR_MESSAGE = "Configuration '%s' must be an object where each key is an initial prefix to be matched and the value is an array of strings representing sub-prefixes to match, where an empty array of sub-prefixes indicates only the initial prefix needs to be matched.";

    static TypeElement findOuterMostClass(Element el) {
        while (el != null && !(el instanceof TypeElement)) {
            el = el.getEnclosingElement();
        }
        if (el == null) {
            return null;
        }
        return ((TypeElement)el).getNestingKind() == NestingKind.TOP_LEVEL ? (TypeElement)el : RevApiUtils.findOuterMostClass(el.getEnclosingElement());
    }

    static List<PrefixMatcher> createPrefixMatchersFromConfiguration(AnalysisContext analysisContext, String propertyName) {
        JsonNode configuration = analysisContext.getConfigurationNode().get(propertyName);
        if (configuration == null) {
            return Collections.emptyList();
        }
        if (!configuration.isObject()) {
            throw new IllegalArgumentException(String.format(CONFIGURATION_ERROR_MESSAGE, propertyName));
        }
        ArrayList<PrefixMatcher> prefixMatchers = new ArrayList<PrefixMatcher>();
        ObjectNode prefixesObject = (ObjectNode)configuration;
        Iterator it = prefixesObject.fields();
        while (it.hasNext()) {
            Map.Entry allowedPrefixKvp = (Map.Entry)it.next();
            String initialPrefix = (String)allowedPrefixKvp.getKey();
            if (initialPrefix.isEmpty()) {
                throw new IllegalArgumentException(String.format(CONFIGURATION_ERROR_MESSAGE, propertyName));
            }
            JsonNode allowedPrefix = (JsonNode)allowedPrefixKvp.getValue();
            if (!allowedPrefix.isArray()) {
                throw new IllegalArgumentException(String.format(CONFIGURATION_ERROR_MESSAGE, propertyName));
            }
            ArrayNode subPrefixes = (ArrayNode)allowedPrefix;
            ArrayList<String> subPrefixList = new ArrayList<String>();
            for (JsonNode subPrefix : subPrefixes) {
                if (!subPrefix.isTextual()) {
                    throw new IllegalArgumentException(String.format(CONFIGURATION_ERROR_MESSAGE, propertyName));
                }
                subPrefixList.add(subPrefix.asText());
            }
            prefixMatchers.add(new PrefixMatcher(initialPrefix, subPrefixList));
        }
        return prefixMatchers;
    }

    private RevApiUtils() {
    }
}

