/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import java.util.List;
import java.util.function.Predicate;

final class PrefixMatcher
implements Predicate<String> {
    private final String initialPrefix;
    private final int initialPrefixLength;
    private final List<String> subPrefixes;

    PrefixMatcher(String initialPrefix, List<String> subPrefixes) {
        this.initialPrefix = initialPrefix;
        this.initialPrefixLength = initialPrefix.length();
        this.subPrefixes = subPrefixes;
    }

    @Override
    public boolean test(String s) {
        if (s == null) {
            return false;
        }
        if (!s.startsWith(this.initialPrefix)) {
            return false;
        }
        if (this.subPrefixes.isEmpty()) {
            return true;
        }
        for (String subPrefix : this.subPrefixes) {
            if (!s.regionMatches(this.initialPrefixLength, subPrefix, 0, subPrefix.length())) continue;
            return true;
        }
        return false;
    }
}

