/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Criticality;
import org.revapi.Difference;
import org.revapi.Element;
import org.revapi.TransformationResult;
import org.revapi.base.BaseDifferenceTransform;

public final class IgnoredTransitiveChangesTransform<E extends Element<E>>
extends BaseDifferenceTransform<E> {
    private static final String CONFIGURATION_ERROR_MESSAGE = "Configuration 'ignoredNewArchives' must be an array of strings representing a Maven groupId:artifactId pair to ignore transitive changes from.";
    private static final String SUPPLEMENTARY = Archive.Role.SUPPLEMENTARY.toString();
    private boolean enabled = false;
    private List<String> ignoredNewArchives = Collections.emptyList();

    public List<Predicate<String>> getDifferenceCodePredicates() {
        return Collections.singletonList(ignored -> true);
    }

    public String getExtensionId() {
        return "ignored-transitive-changes";
    }

    public void initialize(AnalysisContext analysisContext) {
        JsonNode enabledNode = analysisContext.getConfigurationNode().get("enabled");
        this.enabled = enabledNode != null && enabledNode.isBoolean() && enabledNode.booleanValue();
        JsonNode configuration = analysisContext.getConfigurationNode().get("ignoredNewArchives");
        if (configuration != null) {
            if (!configuration.isArray()) {
                throw new IllegalArgumentException(CONFIGURATION_ERROR_MESSAGE);
            }
            ArrayList<String> ignoredNewArchives = new ArrayList<String>();
            for (JsonNode node : configuration) {
                if (!node.isTextual()) {
                    throw new IllegalArgumentException(CONFIGURATION_ERROR_MESSAGE);
                }
                ignoredNewArchives.add(node.asText());
            }
            this.ignoredNewArchives = ignoredNewArchives;
        }
    }

    public TransformationResult tryTransform(E oldElement, E newElement, Difference difference) {
        if (!this.enabled) {
            return TransformationResult.keep();
        }
        String newArchive = (String)difference.attachments.get("newArchive");
        String newArchiveRole = (String)difference.attachments.get("newArchiveRole");
        if (newArchive == null) {
            return TransformationResult.keep();
        }
        if (!SUPPLEMENTARY.equalsIgnoreCase(newArchiveRole)) {
            return TransformationResult.keep();
        }
        boolean shouldKeep = true;
        for (String ignoredNewArchive : this.ignoredNewArchives) {
            if (!newArchive.startsWith(ignoredNewArchive)) continue;
            shouldKeep = false;
            break;
        }
        if (shouldKeep) {
            return TransformationResult.keep();
        }
        if (difference.criticality == Criticality.ERROR) {
            return TransformationResult.discard();
        }
        return TransformationResult.keep();
    }
}

