/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import io.clientcore.linting.extensions.revapi.transforms.PrefixMatcher;
import io.clientcore.linting.extensions.revapi.transforms.RevApiUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.revapi.AnalysisContext;
import org.revapi.Criticality;
import org.revapi.Difference;
import org.revapi.Element;
import org.revapi.TransformationResult;
import org.revapi.base.BaseDifferenceTransform;

public final class IgnoredJacksonDatabindRemovalTransform<E extends Element<E>>
extends BaseDifferenceTransform<E> {
    private boolean enabled = false;
    private List<PrefixMatcher> ignoredPackages = Collections.emptyList();

    public List<Predicate<String>> getDifferenceCodePredicates() {
        return Collections.singletonList("java.annotation.removed"::equals);
    }

    public String getExtensionId() {
        return "ignored-jackson-databind-removal";
    }

    public void initialize(AnalysisContext analysisContext) {
        JsonNode enabledNode = analysisContext.getConfigurationNode().get("enabled");
        this.enabled = enabledNode != null && enabledNode.isBoolean() && enabledNode.booleanValue();
        this.ignoredPackages = RevApiUtils.createPrefixMatchersFromConfiguration(analysisContext, "ignoredPackages");
    }

    public TransformationResult tryTransform(E oldElement, E newElement, Difference difference) {
        if (!this.enabled) {
            return TransformationResult.keep();
        }
        String annotationType = (String)difference.attachments.get("annotationType");
        if (difference.criticality != Criticality.ERROR) {
            return TransformationResult.keep();
        }
        if (annotationType == null || annotationType.isEmpty()) {
            return TransformationResult.keep();
        }
        if (!annotationType.contains("fasterxml.jackson") || !annotationType.contains("annotation")) {
            return TransformationResult.keep();
        }
        String packageName = (String)difference.attachments.get("package");
        if (packageName == null || packageName.isEmpty()) {
            return TransformationResult.keep();
        }
        return this.shouldDiscard(packageName) ? TransformationResult.discard() : TransformationResult.keep();
    }

    private boolean shouldDiscard(String packageName) {
        for (PrefixMatcher prefixMatcher : this.ignoredPackages) {
            if (!prefixMatcher.test(packageName)) continue;
            return true;
        }
        return false;
    }
}

