/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import io.clientcore.linting.extensions.revapi.transforms.PrefixMatcher;
import io.clientcore.linting.extensions.revapi.transforms.RevApiUtils;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.revapi.AnalysisContext;
import org.revapi.ArchiveAnalyzer;
import org.revapi.Element;
import org.revapi.FilterStartResult;
import org.revapi.TreeFilter;
import org.revapi.TreeFilterProvider;
import org.revapi.base.IndependentTreeFilter;
import org.revapi.java.spi.JavaTypeElement;

public final class ClassAndPackageTreeFilterProvider
implements TreeFilterProvider {
    private static final String PATTERN_ERROR_MESSAGE = "Configuration 'ignoredPackagesPatterns' must be an array of strings representing regular expressions to ignore.";
    private List<PrefixMatcher> ignoredClasses = Collections.emptyList();
    private List<PrefixMatcher> ignoredPackages = Collections.emptyList();
    private List<Pattern> ignoredPackagesPatterns = Collections.emptyList();

    public String getExtensionId() {
        return "class-and-package-tree-filter-provider";
    }

    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(AnalysisContext analysisContext) {
        this.ignoredClasses = RevApiUtils.createPrefixMatchersFromConfiguration(analysisContext, "ignoredClasses");
        this.ignoredPackages = RevApiUtils.createPrefixMatchersFromConfiguration(analysisContext, "ignoredPackages");
        JsonNode patterns = analysisContext.getConfigurationNode().get("ignoredPackagesPatterns");
        if (patterns != null) {
            if (!patterns.isArray()) {
                throw new IllegalArgumentException(PATTERN_ERROR_MESSAGE);
            }
            ArrayList<Pattern> ignoredPackagesPatterns = new ArrayList<Pattern>();
            for (JsonNode pattern : patterns) {
                if (!pattern.isTextual()) {
                    throw new IllegalArgumentException(PATTERN_ERROR_MESSAGE);
                }
                ignoredPackagesPatterns.add(Pattern.compile(pattern.asText()));
            }
            this.ignoredPackagesPatterns = ignoredPackagesPatterns;
        }
    }

    public <E extends Element<E>> Optional<TreeFilter<E>> filterFor(ArchiveAnalyzer<E> archiveAnalyzer) {
        if (!"revapi.java".equals(archiveAnalyzer.getApiAnalyzer().getExtensionId())) {
            return Optional.empty();
        }
        return Optional.of(new IndependentTreeFilter<E>(){

            protected FilterStartResult doStart(E element) {
                boolean excludeClass;
                if (!(element instanceof JavaTypeElement)) {
                    return FilterStartResult.defaultResult();
                }
                TypeElement outermostClass = RevApiUtils.findOuterMostClass(((JavaTypeElement)element).getDeclaringElement());
                boolean bl = excludeClass = outermostClass != null && ClassAndPackageTreeFilterProvider.this.excludeClass(outermostClass.getQualifiedName().toString());
                if (excludeClass) {
                    return FilterStartResult.doesntMatch();
                }
                PackageElement packageElement = ClassAndPackageTreeFilterProvider.findPackage((JavaTypeElement)element);
                if (packageElement == null) {
                    return FilterStartResult.defaultResult();
                }
                String packageName = packageElement.getQualifiedName().toString();
                boolean excludePackage = ClassAndPackageTreeFilterProvider.this.excludePackage(packageName);
                return excludePackage ? FilterStartResult.doesntMatch() : FilterStartResult.matchAndDescend();
            }
        });
    }

    boolean excludeClass(String className) {
        for (PrefixMatcher matcher : this.ignoredClasses) {
            if (!matcher.test(className)) continue;
            return true;
        }
        return false;
    }

    private static PackageElement findPackage(JavaTypeElement element) {
        javax.lang.model.element.Element el;
        for (el = element.getDeclaringElement(); el != null && !(el instanceof PackageElement); el = el.getEnclosingElement()) {
        }
        return (PackageElement)el;
    }

    boolean excludePackage(String packageName) {
        for (PrefixMatcher matcher : this.ignoredPackages) {
            if (!matcher.test(packageName)) continue;
            return true;
        }
        for (Pattern pattern : this.ignoredPackagesPatterns) {
            if (!pattern.matcher(packageName).matches()) continue;
            return true;
        }
        return false;
    }

    public void close() {
    }
}

