/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.revapi.transforms;

import com.fasterxml.jackson.databind.JsonNode;
import io.clientcore.linting.extensions.revapi.transforms.PrefixMatcher;
import io.clientcore.linting.extensions.revapi.transforms.RevApiUtils;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.lang.model.element.TypeElement;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.Element;
import org.revapi.TransformationResult;
import org.revapi.base.BaseDifferenceTransform;
import org.revapi.java.spi.JavaTypeElement;

public final class AllowedExternalApis<E extends Element<E>>
extends BaseDifferenceTransform<E> {
    private boolean enabled = false;
    private List<PrefixMatcher> allowedPrefixes = Collections.emptyList();

    public List<Predicate<String>> getDifferenceCodePredicates() {
        return Collections.singletonList("java.class.externalClassExposedInAPI"::equals);
    }

    public TransformationResult tryTransform(E oldElement, E newElement, Difference difference) {
        if (!this.enabled || newElement == null || this.allowedPrefixes.isEmpty()) {
            return TransformationResult.keep();
        }
        if (!(newElement instanceof JavaTypeElement)) {
            return TransformationResult.keep();
        }
        TypeElement outermostElement = RevApiUtils.findOuterMostClass(((JavaTypeElement)newElement).getDeclaringElement());
        if (outermostElement == null) {
            return TransformationResult.keep();
        }
        String className = outermostElement.getQualifiedName().toString();
        for (PrefixMatcher prefixMatcher : this.allowedPrefixes) {
            if (!prefixMatcher.test(className)) continue;
            return TransformationResult.discard();
        }
        return TransformationResult.keep();
    }

    public String getExtensionId() {
        return "allowed-external-apis";
    }

    public void initialize(AnalysisContext analysisContext) {
        JsonNode enabledNode = analysisContext.getConfigurationNode().get("enabled");
        this.enabled = enabledNode != null && enabledNode.isBoolean() && enabledNode.booleanValue();
        this.allowedPrefixes = RevApiUtils.createPrefixMatchersFromConfiguration(analysisContext, "allowedPrefixes");
    }
}

