/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkCheckFilter
implements Filter {
    private static final Pattern SAMPLE_OR_TEST_FILE_PATTERN = Pattern.compile(".*src[/\\\\](samples|test|test-shared)[/\\\\]java[/\\\\].*\\.java$");
    private static final Pattern IMPLEMENTATION_FILE_PATTERN = Pattern.compile(".*src[/\\\\].*[/\\\\]implementation[/\\\\].*\\.java$");
    private static final String SDK_CHECK_START = "io.clientcore.linting.extensions.checkstyle.checks.";
    private static final String EXTERNAL_DEPENDENCY_EXPOSED = "io.clientcore.linting.extensions.checkstyle.checks.ExternalDependencyExposed";

    public boolean accept(AuditEvent event) {
        boolean shouldSkip = SdkCheckFilter.isIgnoredImplementation(event) || SdkCheckFilter.isIgnoredSampleOrTest(event);
        return !shouldSkip;
    }

    private static boolean isIgnoredSampleOrTest(AuditEvent event) {
        Matcher matcher = SAMPLE_OR_TEST_FILE_PATTERN.matcher(event.getFileName());
        if (!matcher.matches()) {
            return false;
        }
        boolean isTestFile = matcher.group(1).startsWith("test");
        String violation = event.getViolation().getSourceName();
        if (violation.toLowerCase().contains("javadoc")) {
            return true;
        }
        if (isTestFile && violation.contains("AvoidStarImport")) {
            return true;
        }
        if (isTestFile && violation.contains("AvoidNestedBlocks")) {
            return true;
        }
        if (violation.startsWith(SDK_CHECK_START)) {
            return true;
        }
        if (violation.contains("LineLength")) {
            return true;
        }
        return !isTestFile && violation.contains("EqualsAvoidNull");
    }

    private static boolean isIgnoredImplementation(AuditEvent event) {
        Matcher matcher = IMPLEMENTATION_FILE_PATTERN.matcher(event.getFileName());
        if (!matcher.matches()) {
            return false;
        }
        String violation = event.getViolation().getSourceName();
        return violation.startsWith(EXTERNAL_DEPENDENCY_EXPOSED) || violation.toLowerCase().contains("javadoc");
    }
}

