/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class UseCaughtExceptionCauseCheck
extends AbstractCheck {
    static final String UNUSED_CAUGHT_EXCEPTION_ERROR = "Caught and thrown exceptions should include the caught exception as the cause in the newly thrown exception. Dropping the causal exception makes it more difficult to troubleshoot issues when they arise. Include the caught exception variable %s as the cause.";

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{96};
    }

    public void visitToken(DetailAST catchBlockToken) {
        DetailAST catchStatement = catchBlockToken.findFirstToken(21);
        String caughtExceptionVariableName = catchStatement.findFirstToken(58).getText();
        List<String> wrappedExceptions = this.getWrappedExceptions(catchBlockToken, catchBlockToken, caughtExceptionVariableName);
        UseCaughtExceptionCauseCheck.forEachThrowStatement(catchBlockToken, throwToken -> {
            HashSet<String> throwParamNames = new HashSet<String>();
            UseCaughtExceptionCauseCheck.getThrowParamNames(throwToken, throwParamNames);
            wrappedExceptions.add(caughtExceptionVariableName);
            if (wrappedExceptions.stream().noneMatch(throwParamNames::contains)) {
                this.log((DetailAST)throwToken, String.format(UNUSED_CAUGHT_EXCEPTION_ERROR, caughtExceptionVariableName), new Object[0]);
            }
        });
    }

    private List<String> getWrappedExceptions(DetailAST currentCatchAST, DetailAST detailAST, String caughtExceptionVariableName) {
        ArrayList<String> wrappedExceptionNames = new ArrayList<String>();
        UseCaughtExceptionCauseCheck.forEachChildNode(detailAST, currentNode -> {
            if (currentNode.getType() == 58 && currentNode.getText().equals(caughtExceptionVariableName)) {
                UseCaughtExceptionCauseCheck.getWrappedExceptionVariable(currentCatchAST, wrappedExceptionNames, currentNode);
            }
            if (currentNode.getFirstChild() != null) {
                wrappedExceptionNames.addAll(this.getWrappedExceptions(currentCatchAST, (DetailAST)currentNode, caughtExceptionVariableName));
            }
        });
        return wrappedExceptionNames;
    }

    private static void getWrappedExceptionVariable(DetailAST currentCatchBlock, List<String> wrappedExceptionNames, DetailAST currentToken) {
        DetailAST wrappedException;
        DetailAST temp = currentToken;
        while (!temp.equals((Object)currentCatchBlock) && temp.getType() != 80) {
            temp = temp.getParent();
        }
        if (temp.getType() == 80 && (wrappedException = temp.getParent().getType() == 10 ? temp.getParent().findFirstToken(58) : (temp.findFirstToken(59) != null ? temp.findFirstToken(59).findFirstToken(58) : temp.findFirstToken(58))) != null) {
            wrappedExceptionNames.add(wrappedException.getText());
        }
    }

    private static void getThrowParamNames(DetailAST throwParent, Set<String> paramNames) {
        UseCaughtExceptionCauseCheck.forEachChildNode(throwParent, currentNode -> {
            if (currentNode.getType() == 58) {
                paramNames.add(currentNode.getText());
            }
            if (currentNode.getFirstChild() != null) {
                UseCaughtExceptionCauseCheck.getThrowParamNames(currentNode, paramNames);
            }
        });
    }

    private static void forEachThrowStatement(DetailAST catchBlockToken, Consumer<DetailAST> forEach) {
        UseCaughtExceptionCauseCheck.forEachChildNode(catchBlockToken, currentNode -> {
            if (90 == currentNode.getType()) {
                forEach.accept((DetailAST)currentNode);
            }
            if (currentNode.getFirstChild() != null) {
                UseCaughtExceptionCauseCheck.forEachThrowStatement(currentNode, forEach);
            }
        });
    }

    private static void forEachChildNode(DetailAST token, Consumer<DetailAST> forEach) {
        for (DetailAST currNode = token.getFirstChild(); currNode != null; currNode = currNode.getNextSibling()) {
            forEach.accept(currNode);
        }
    }
}

