/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Queue;

public class ThrowFromClientLoggerCheck
extends AbstractCheck {
    private static final String LOGGER_LOG_EXCEPTION_AS_ERROR = "logger.logExceptionAsError";
    private static final String LOGGER_LOG_THROWABLE_AS_ERROR = "logger.logThrowableAsError";
    private static final String LOGGING_BUILDER_LOG_THROWABLE_AS_ERROR = "logger.atError().log";
    private static final String LOGGER_LOG_EXCEPTION_AS_WARNING = "logger.logExceptionAsWarning";
    private static final String LOGGER_LOG_THROWABLE_AS_WARNING = "logger.logThrowableAsWarning";
    private static final String LOGGING_BUILDER_LOG_THROWABLE_AS_WARNING = "logger.atWarning().log";
    static final String THROW_LOGGER_EXCEPTION_MESSAGE = String.format("Directly throwing an exception is disallowed. Must throw through \"ClientLogger\" API, either of \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", or \"%s\" where \"logger\" is type of ClientLogger from Azure Core package.", "logger.logExceptionAsError", "logger.logThrowableAsError", "logger.atError().log", "logger.logExceptionAsWarning", "logger.logThrowableAsWarning", "logger.atWarning().log");
    private final Queue<Boolean> classStaticDeque = Collections.asLifoQueue(new ArrayDeque());
    private final Queue<Boolean> methodStaticDeque = Collections.asLifoQueue(new ArrayDeque());
    private boolean isInConstructor = false;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 8, 90, 9};
    }

    public void leaveToken(DetailAST token) {
        if (token.getType() == 14) {
            this.classStaticDeque.poll();
        } else if (token.getType() == 8) {
            this.isInConstructor = false;
        } else if (token.getType() == 9) {
            this.methodStaticDeque.poll();
        }
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 14) {
            DetailAST modifiersToken = token.findFirstToken(5);
            this.classStaticDeque.offer(modifiersToken.findFirstToken(64) != null);
        } else if (token.getType() == 8) {
            this.isInConstructor = true;
        } else if (token.getType() == 9) {
            DetailAST methodModifiersToken = token.findFirstToken(5);
            this.methodStaticDeque.offer(methodModifiersToken.findFirstToken(64) != null);
        } else if (token.getType() == 90) {
            if (this.classStaticDeque.isEmpty() || this.classStaticDeque.peek().booleanValue() || this.isInConstructor || this.methodStaticDeque.isEmpty() || this.methodStaticDeque.peek().booleanValue() || ThrowFromClientLoggerCheck.findLogMethodIdentifier(token)) {
                return;
            }
            DetailAST methodCallToken = token.findFirstToken(28).findFirstToken(27);
            if (methodCallToken == null) {
                this.log(token, THROW_LOGGER_EXCEPTION_MESSAGE, new Object[0]);
                return;
            }
            String methodCallName = FullIdent.createFullIdent((DetailAST)methodCallToken.findFirstToken(59)).getText();
            if (!(LOGGER_LOG_EXCEPTION_AS_ERROR.equalsIgnoreCase(methodCallName) || LOGGER_LOG_THROWABLE_AS_ERROR.equalsIgnoreCase(methodCallName) || LOGGER_LOG_EXCEPTION_AS_WARNING.equalsIgnoreCase(methodCallName) || LOGGER_LOG_THROWABLE_AS_WARNING.equalsIgnoreCase(methodCallName))) {
                this.log(token, THROW_LOGGER_EXCEPTION_MESSAGE, new Object[0]);
            }
        }
    }

    private static boolean findLogMethodIdentifier(DetailAST root) {
        for (DetailAST ast = root.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            DetailAST ident;
            DetailAST dot;
            if (ast.getType() == 27 && (dot = ast.findFirstToken(59)) != null && "log".equals((ident = dot.findFirstToken(58)).getText())) {
                return true;
            }
            if (!ThrowFromClientLoggerCheck.findLogMethodIdentifier(ast)) continue;
            return true;
        }
        return false;
    }
}

