/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.Arrays;
import java.util.List;

public class StringFormattedExceptionMessageCheck
extends AbstractCheck {
    static final String ERROR_MESSAGE = "Short message passed to \"logger.throwableAt*().log\" should be static. Provide dynamic components using the \"addKeyValue(key, value)\" method instead. See https://github.com/Azure/azure-sdk-for-java/wiki/Client-core:-logging-exceptions-best-practices for more details.";
    private static final List<String> THROWABLE_AT_LOGGING_METHODS = Arrays.asList(".throwableAtError", ".throwableAtWarning");
    private static final String LOG_METHOD_NAME = ".log";
    private static final String STRING_FORMAT_METHOD_NAME = "String.format";

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{27};
    }

    public void visitToken(DetailAST token) {
        String name = FullIdent.createFullIdentBelow((DetailAST)token).getText();
        if (THROWABLE_AT_LOGGING_METHODS.stream().anyMatch(name::endsWith)) {
            DetailAST logMethodCall = token.getParent().getParent();
            if (logMethodCall == null || logMethodCall.getType() != 27) {
                return;
            }
            String nextName = FullIdent.createFullIdentBelow((DetailAST)logMethodCall).getText();
            if (nextName.endsWith(LOG_METHOD_NAME)) {
                DetailAST elist = logMethodCall.findFirstToken(34);
                if (elist == null) {
                    return;
                }
                DetailAST logExpr = elist.findFirstToken(28);
                if (logExpr == null) {
                    return;
                }
                DetailAST firstParam = logExpr.getFirstChild();
                if (firstParam.getType() == 27) {
                    String logFirstArgMethod = FullIdent.createFullIdentBelow((DetailAST)logExpr.getFirstChild()).getText();
                    if (logFirstArgMethod.endsWith(STRING_FORMAT_METHOD_NAME)) {
                        this.log(logExpr, ERROR_MESSAGE, new Object[0]);
                    }
                } else if (firstParam.getType() == 125) {
                    DetailAST firstIdent = logExpr.getFirstChild().findFirstToken(58);
                    DetailAST firstLiteral = logExpr.getFirstChild().findFirstToken(139);
                    if (firstIdent != null && firstLiteral != null) {
                        this.log(firstParam, ERROR_MESSAGE, new Object[0]);
                    }
                }
            }
        }
    }
}

