/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class StepVerifierCheck
extends AbstractCheck {
    private static final String SET_DEFAULT_TIMEOUT = "setDefaultTimeout";
    private static final String FULLY_QUALIFIED = "reactor.test.StepVerifier.setDefaultTimeout";
    private static final String METHOD_CALL = "StepVerifier.setDefaultTimeout";
    static final String ERROR_MESSAGE = "Do not use StepVerifier.setDefaultTimeout as it can affect other tests. Instead use expect* methods on StepVerifier and use verify(Duration) to set timeouts on a test-by-test basis.";
    private boolean hasStaticImport;

    public int[] getDefaultTokens() {
        return new int[]{27, 152};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void init() {
        super.init();
        this.hasStaticImport = false;
    }

    public void destroy() {
        super.destroy();
        this.hasStaticImport = false;
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 152) {
            this.hasStaticImport = FULLY_QUALIFIED.equals(FullIdent.createFullIdent((DetailAST)ast.getFirstChild().getNextSibling()).getText());
        } else {
            FullIdent fullIdent = FullIdent.createFullIdentBelow((DetailAST)ast);
            if (this.hasStaticImport && SET_DEFAULT_TIMEOUT.equals(fullIdent.getText())) {
                this.log(ast.getLineNo(), fullIdent.getColumnNo(), ERROR_MESSAGE, new Object[0]);
            } else if (METHOD_CALL.equals(fullIdent.getText())) {
                this.log(ast.getLineNo(), fullIdent.getColumnNo(), ERROR_MESSAGE, new Object[0]);
            } else if (FULLY_QUALIFIED.equals(fullIdent.getText())) {
                this.log(ast.getLineNo(), fullIdent.getColumnNo(), ERROR_MESSAGE, new Object[0]);
            }
        }
    }
}

