/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ServiceInterfaceCheck
extends AbstractCheck {
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{15};
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 15) {
            this.checkServiceInterface(token);
        }
    }

    private void checkServiceInterface(DetailAST interfaceDefToken) {
        DetailAST serviceInterfaceAnnotationNode = null;
        String nameValue = null;
        DetailAST modifiersToken = interfaceDefToken.findFirstToken(5);
        for (DetailAST ast = modifiersToken.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != 159 || !"ServiceInterface".equals(ast.findFirstToken(58).getText())) continue;
            serviceInterfaceAnnotationNode = ast;
            DetailAST annotationMemberValuePairToken = ast.findFirstToken(160);
            if (!"name".equals(annotationMemberValuePairToken.findFirstToken(58).getText())) continue;
            nameValue = this.getNamePropertyValue(annotationMemberValuePairToken.findFirstToken(28));
            break;
        }
        if (serviceInterfaceAnnotationNode == null) {
            return;
        }
        if (nameValue == null || nameValue.isEmpty()) {
            this.log(serviceInterfaceAnnotationNode, String.format("The ''name'' property of @ServiceInterface, ''%s'' should be not be null or empty", nameValue), new Object[0]);
        }
    }

    private String getNamePropertyValue(DetailAST exprToken) {
        if (exprToken == null) {
            return null;
        }
        DetailAST nameValueToken = exprToken.findFirstToken(139);
        if (nameValueToken == null) {
            return null;
        }
        String nameValue = nameValueToken.getText();
        return nameValue.replaceAll("^\"|\"$", "");
    }
}

