/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import io.clientcore.linting.extensions.checkstyle.checks.SdkCheckUtils;
import java.util.HashMap;
import java.util.Map;

public class ServiceClientCheck
extends AbstractCheck {
    private static final String ASYNC = "Async";
    private static final String SERVICE_CLIENT = "ServiceClient";
    private static final String BUILDER = "builder";
    private static final String ASYNC_CLIENT = "AsyncClient";
    private static final String CLIENT = "Client";
    private static final String IS_ASYNC = "isAsync";
    private static final String CONTEXT = "Context";
    private static final String REQUEST_OPTIONS = "RequestOptions";
    private static final String RESPONSE_BRACKET = "Response<";
    private static final String MONO_BRACKET = "Mono<";
    private static final String MONO_RESPONSE_BRACKET = "Mono<Response<";
    private static final String PAGED_FLUX_BRACKET = "PagedFlux<";
    private static final String POLLER_FLUX_BRACKET = "PollerFlux<";
    private static final String SYNC_POLLER_BRACKET = "SyncPoller<";
    private static final String WITH_RESPONSE = "WithResponse";
    private static final String COLLECTION_RETURN_TYPE = "ReturnType.COLLECTION";
    private static final String SINGLE_RETURN_TYPE = "ReturnType.SINGLE";
    private static final String LONG_RUNNING_OPERATION_RETURN_TYPE = "ReturnType.LONG_RUNNING_OPERATION";
    private static final String PAGED_FLUX = "PagedFlux";
    private static final String POLLER_FLUX = "PollerFlux";
    private static final String SYNC_POLLER = "SyncPoller";
    private static final String MONO = "Mono";
    private static final String RESPONSE = "Response";
    private static final String PAGED_ITERABLE = "PagedIterable";
    private static final String RETURN_TYPE_WITH_RESPONSE_ERROR = "Return type is ''%s'', the method name %s end with ''%s''.";
    private static final String RETURN_TYPE_ERROR = "''%s'' service client with ''%s'' should use type ''%s'' as the return type.";
    private static final String RESPONSE_METHOD_NAME_ERROR = "''%s'' service client with ''%s'', should always use return type ''%s'' if method name ends with ''%s'' or should always named method name ends with ''%s'' if the return type is ''%s''.";
    private static final String ASYNC_CONTEXT_ERROR = "Asynchronous method with annotation @ServiceMethod must not have ''%s'' as a method parameter.";
    private static final String SYNC_CONTEXT_ERROR = "Synchronous method with annotation @ServiceMethod must have ''%s'' or ''%s'' as a method parameter.";
    private final Map<String, String> simpleClassNameToQualifiedNameMap = new HashMap<String, String>();
    private boolean isAsync;
    private boolean isServiceClientAnnotation;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{30, 14, 8, 9, 6};
    }

    public void beginTree(DetailAST root) {
        this.isServiceClientAnnotation = false;
        this.isAsync = false;
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 30) {
            this.addImportedClassPath(token);
        } else if (token.getType() == 14) {
            this.isServiceClientAnnotation = this.hasServiceClientAnnotation(token);
            if (!this.isServiceClientAnnotation) {
                return;
            }
            this.checkServiceClientNaming(token);
        } else if (token.getType() == 8 && this.isServiceClientAnnotation) {
            this.checkConstructor(token);
        } else if (token.getType() == 9 && this.isServiceClientAnnotation) {
            this.checkMethodNameBuilder(token);
            this.checkMethodNamingPattern(token);
        } else if (token.getType() == 6 && this.isServiceClientAnnotation) {
            this.checkClassField(token);
        }
    }

    private void checkConstructor(DetailAST ctorToken) {
        if (SdkCheckUtils.isPublicOrProtected(ctorToken)) {
            this.log(ctorToken, "@ServiceClient class should not have any public or protected constructor.", new Object[0]);
        }
    }

    private void checkMethodNameBuilder(DetailAST methodDefToken) {
        DetailAST methodNameToken = methodDefToken.findFirstToken(58);
        if (!BUILDER.equals(methodNameToken.getText())) {
            return;
        }
        DetailAST modifiersToken = methodDefToken.findFirstToken(5);
        AccessModifierOption accessModifier = CheckUtil.getAccessModifierFromModifiersToken((DetailAST)methodDefToken);
        if (accessModifier.equals((Object)AccessModifierOption.PUBLIC) && modifiersToken.branchContains(64)) {
            this.log(methodDefToken, "@ServiceClient class should not have a public static method named ''builder''.", new Object[0]);
        }
    }

    private void checkClassField(DetailAST objBlockToken) {
        TokenUtil.findFirstTokenByPredicate((DetailAST)objBlockToken, node -> node.getType() == 10 && !node.findFirstToken(5).branchContains(39)).ifPresent(varDefToken -> {
            String varName = varDefToken.findFirstToken(58).getText();
            this.log((DetailAST)varDefToken, String.format("The variable field ''%s'' of class ''%s'' should be final. Classes annotated with @ServiceClient are supposed to be immutable.", varName, objBlockToken.getPreviousSibling().getText()), new Object[0]);
        });
    }

    private void checkServiceClientNaming(DetailAST classDefToken) {
        String className = classDefToken.findFirstToken(58).getText();
        if (this.isAsync && !className.endsWith(ASYNC_CLIENT)) {
            this.log(classDefToken, String.format("Asynchronous class ''%s'' must be named <ServiceName>AsyncClient, which concatenates by service name and a fixed word 'AsyncClient'.", className), new Object[0]);
        } else if (!this.isAsync && !className.endsWith(CLIENT)) {
            this.log(classDefToken, String.format("Synchronous class %s must be named <ServiceName>Client, which concatenates by service name and a fixed word 'Client'.", className), new Object[0]);
        }
        if (className.endsWith(ASYNC_CLIENT) && !this.isAsync) {
            this.log(classDefToken, String.format("class ''%s'' is an asynchronous client, must set property ''%s'' to true.", className, IS_ASYNC), new Object[0]);
        } else if (className.endsWith(CLIENT) && !className.endsWith(ASYNC_CLIENT) && this.isAsync) {
            this.log(classDefToken, String.format("class ''%s'' is a synchronous client, must set property ''%s'' to false or without the property.", className, IS_ASYNC), new Object[0]);
        }
    }

    private void checkMethodNamingPattern(DetailAST methodDefToken) {
        DetailAST modifiersToken = methodDefToken.findFirstToken(5);
        TokenUtil.findFirstTokenByPredicate((DetailAST)modifiersToken, node -> {
            if (node.getType() != 159) {
                return false;
            }
            DetailAST annotationIdentToken = node.findFirstToken(58);
            return annotationIdentToken != null && "ServiceMethod".equals(annotationIdentToken.getText());
        }).ifPresent(serviceMethodAnnotation -> {
            String methodName = methodDefToken.findFirstToken(58).getText();
            if (methodName.contains(ASYNC)) {
                this.log(methodDefToken, String.format("Method name ''%s'' should not contain ''%s'' in the method name.", methodName, ASYNC), new Object[0]);
            }
            this.checkServiceClientMethodReturnType(methodDefToken, (DetailAST)serviceMethodAnnotation, methodName);
            this.checkReturnTypeNamingPattern(methodDefToken, methodName);
            this.checkContextInRightPlace(methodDefToken);
        });
    }

    private void checkServiceClientMethodReturnType(DetailAST methodDefToken, DetailAST serviceMethodAnnotation, String methodName) {
        TokenUtil.findFirstTokenByPredicate((DetailAST)serviceMethodAnnotation, node -> node.getType() == 160 && node.findFirstToken(58).getText().equals("returns") && !FullIdent.createFullIdentBelow((DetailAST)node.findFirstToken(28)).getText().isEmpty()).ifPresent(valueOptions -> {
            String returnsAnnotationMemberValue = FullIdent.createFullIdentBelow((DetailAST)valueOptions.findFirstToken(28)).getText();
            String returnType = ServiceClientCheck.getReturnType(methodDefToken.findFirstToken(13), new StringBuilder()).toString();
            if (this.isAsync) {
                if (SINGLE_RETURN_TYPE.equals(returnsAnnotationMemberValue)) {
                    if (!returnType.startsWith(MONO_BRACKET)) {
                        this.log(methodDefToken, String.format(RETURN_TYPE_ERROR, "Asynchronous", SINGLE_RETURN_TYPE, MONO), new Object[0]);
                    }
                } else if (COLLECTION_RETURN_TYPE.equals(returnsAnnotationMemberValue)) {
                    if (!returnType.contains(PAGED_FLUX)) {
                        this.log(methodDefToken, String.format(RETURN_TYPE_ERROR, "Asynchronous", COLLECTION_RETURN_TYPE, PAGED_FLUX), new Object[0]);
                    }
                } else if (LONG_RUNNING_OPERATION_RETURN_TYPE.equals(returnsAnnotationMemberValue) && !returnType.contains(POLLER_FLUX_BRACKET)) {
                    this.log(methodDefToken, String.format(RETURN_TYPE_ERROR, "Asynchronous", LONG_RUNNING_OPERATION_RETURN_TYPE, POLLER_FLUX), new Object[0]);
                }
            } else if (SINGLE_RETURN_TYPE.equals(returnsAnnotationMemberValue)) {
                if (returnType.startsWith(RESPONSE_BRACKET) && !methodName.endsWith(WITH_RESPONSE) || !returnType.startsWith(RESPONSE_BRACKET) && methodName.endsWith(WITH_RESPONSE)) {
                    this.log(methodDefToken, String.format(RESPONSE_METHOD_NAME_ERROR, "Synchronous", SINGLE_RETURN_TYPE, RESPONSE, WITH_RESPONSE, WITH_RESPONSE, RESPONSE), new Object[0]);
                }
            } else if (COLLECTION_RETURN_TYPE.equals(returnsAnnotationMemberValue)) {
                if (!returnType.contains(PAGED_ITERABLE)) {
                    this.log(methodDefToken, String.format(RETURN_TYPE_ERROR, "Synchronous", COLLECTION_RETURN_TYPE, PAGED_ITERABLE), new Object[0]);
                }
            } else if (LONG_RUNNING_OPERATION_RETURN_TYPE.equals(returnsAnnotationMemberValue) && !returnType.contains(SYNC_POLLER_BRACKET)) {
                this.log(methodDefToken, String.format(RETURN_TYPE_ERROR, "Synchronous", LONG_RUNNING_OPERATION_RETURN_TYPE, SYNC_POLLER), new Object[0]);
            }
        });
    }

    private void checkReturnTypeNamingPattern(DetailAST methodDefToken, String methodName) {
        DetailAST typeToken = methodDefToken.findFirstToken(13);
        String returnType = ServiceClientCheck.getReturnType(typeToken, new StringBuilder()).toString();
        if (methodName.endsWith(WITH_RESPONSE)) {
            if (!returnType.startsWith(RESPONSE_BRACKET) && !returnType.startsWith(MONO_RESPONSE_BRACKET)) {
                this.log(methodDefToken, String.format(RETURN_TYPE_WITH_RESPONSE_ERROR, returnType, "must not", WITH_RESPONSE), new Object[0]);
            }
        } else if (returnType.startsWith(RESPONSE_BRACKET) || returnType.startsWith(MONO_RESPONSE_BRACKET)) {
            this.log(methodDefToken, String.format(RETURN_TYPE_WITH_RESPONSE_ERROR, returnType, "must", WITH_RESPONSE), new Object[0]);
        }
    }

    private void checkContextInRightPlace(DetailAST methodDefToken) {
        DetailAST parametersToken = methodDefToken.findFirstToken(20);
        String returnType = ServiceClientCheck.getReturnType(methodDefToken.findFirstToken(13), new StringBuilder()).toString();
        boolean containsContextParameter = TokenUtil.findFirstTokenByPredicate((DetailAST)parametersToken, parameterToken -> {
            if (parameterToken.getType() != 21) {
                return false;
            }
            DetailAST paramTypeIdentToken = parameterToken.findFirstToken(13).findFirstToken(58);
            return paramTypeIdentToken != null && CONTEXT.equals(paramTypeIdentToken.getText());
        }).isPresent();
        boolean containsRequestOptionsParameter = TokenUtil.findFirstTokenByPredicate((DetailAST)parametersToken, parameterToken -> {
            if (parameterToken.getType() != 21) {
                return false;
            }
            DetailAST paramTypeIdentToken = parameterToken.findFirstToken(13).findFirstToken(58);
            return paramTypeIdentToken != null && REQUEST_OPTIONS.equals(paramTypeIdentToken.getText());
        }).isPresent();
        if (containsContextParameter) {
            if (returnType.startsWith(MONO_BRACKET) || returnType.startsWith(PAGED_FLUX_BRACKET) || returnType.startsWith(POLLER_FLUX_BRACKET)) {
                this.log(methodDefToken, String.format(ASYNC_CONTEXT_ERROR, CONTEXT), new Object[0]);
            }
        } else if (!containsRequestOptionsParameter && returnType.startsWith(RESPONSE_BRACKET)) {
            this.log(methodDefToken, String.format(SYNC_CONTEXT_ERROR, CONTEXT, REQUEST_OPTIONS), new Object[0]);
        }
    }

    private boolean hasServiceClientAnnotation(DetailAST classDefToken) {
        DetailAST modifiersToken = classDefToken.findFirstToken(5);
        return TokenUtil.findFirstTokenByPredicate((DetailAST)modifiersToken, node -> {
            if (node.getType() != 159) {
                return false;
            }
            DetailAST annotationIdentToken = node.findFirstToken(58);
            return annotationIdentToken != null && SERVICE_CLIENT.equals(annotationIdentToken.getText());
        }).map(annotationOptions -> {
            this.isAsync = this.isAsyncServiceClient((DetailAST)annotationOptions);
            return true;
        }).orElse(false);
    }

    private void addImportedClassPath(DetailAST token) {
        String importClassPath = FullIdent.createFullIdentBelow((DetailAST)token).getText();
        String className = importClassPath.substring(importClassPath.lastIndexOf(".") + 1);
        this.simpleClassNameToQualifiedNameMap.put(className, importClassPath);
    }

    private boolean isAsyncServiceClient(DetailAST annotationToken) {
        for (DetailAST ast = annotationToken.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            DetailAST exprToken;
            DetailAST identToken;
            if (ast.getType() != 160 || (identToken = ast.findFirstToken(58)) == null || !IS_ASYNC.equals(identToken.getText()) || (exprToken = ast.findFirstToken(28)) == null) continue;
            return exprToken.branchContains(133);
        }
        return false;
    }

    private static StringBuilder getReturnType(DetailAST token, StringBuilder sb) {
        block3: for (DetailAST currentToken = token.getFirstChild(); currentToken != null; currentToken = currentToken.getNextSibling()) {
            switch (currentToken.getType()) {
                case 163: 
                case 164: {
                    ServiceClientCheck.getReturnType(currentToken, sb);
                    continue block3;
                }
                default: {
                    sb.append(currentToken.getText());
                }
            }
        }
        return sb;
    }
}

