/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.Stack;

public class ServiceClientBuilderCheck
extends AbstractCheck {
    private final Stack<Boolean> hasServiceClientBuilderAnnotationStack = new Stack();
    private final Stack<Boolean> hasBuildMethodStack = new Stack();
    private boolean hasServiceClientBuilderAnnotation;
    private boolean hasBuildMethod;

    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public int[] getRequiredTokens() {
        return new int[]{14, 9};
    }

    public void leaveToken(DetailAST token) {
        if (token.getType() == 14) {
            this.hasServiceClientBuilderAnnotation = this.hasServiceClientBuilderAnnotationStack.pop();
            this.hasBuildMethod = this.hasBuildMethodStack.pop();
            if (this.hasServiceClientBuilderAnnotation && !this.hasBuildMethod) {
                this.log(token, "Class with @ServiceClientBuilder annotation must have a method starting with ''build'' and ending with ''Client''.", new Object[0]);
            }
        }
    }

    public void visitToken(DetailAST token) {
        if (token.getType() == 14) {
            this.hasServiceClientBuilderAnnotationStack.push(this.hasServiceClientBuilderAnnotation);
            this.hasBuildMethodStack.push(this.hasBuildMethod);
            DetailAST serviceClientAnnotationBuilderToken = ServiceClientBuilderCheck.getServiceClientBuilderAnnotation(token);
            String className = token.findFirstToken(58).getText();
            boolean bl = this.hasServiceClientBuilderAnnotation = serviceClientAnnotationBuilderToken != null;
            if (this.hasServiceClientBuilderAnnotation) {
                if (!className.endsWith("ClientBuilder")) {
                    this.log(token, "Class annotated with @ServiceClientBuilder ''" + className + "'' should be named <ServiceName>ClientBuilder.", new Object[0]);
                }
            } else if (className.endsWith("ClientBuilder")) {
                this.log(token, "Class ''" + className + "'' should be annotated with @ServiceClientBuilder.", new Object[0]);
            }
        } else if (token.getType() == 9 && this.hasServiceClientBuilderAnnotation) {
            String methodName = token.findFirstToken(58).getText();
            if (!methodName.startsWith("build")) {
                return;
            }
            this.hasBuildMethod = true;
            if (!methodName.endsWith("Client")) {
                this.log(token, "@ServiceClientBuilder class should not have a method name, ''" + methodName + "'' starting with ''build'' but not ending with ''Client''.", new Object[0]);
            }
        }
    }

    private static DetailAST getServiceClientBuilderAnnotation(DetailAST classDefToken) {
        return AnnotationUtil.getAnnotation((DetailAST)classDefToken, (String)"ServiceClientBuilder");
    }
}

