/*
 * Decompiled with CFR 0.152.
 */
package io.clientcore.linting.extensions.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public final class SdkCheckUtils {
    public static boolean hasIllegalCombination(DetailAST modifiers) {
        if (modifiers.getType() != 5) {
            return false;
        }
        return TokenUtil.findFirstTokenByPredicate((DetailAST)modifiers, node -> {
            int type = node.getType();
            return SdkCheckUtils.invalidFinalCombination(type) || SdkCheckUtils.invalidFinalAnnotation(type, node);
        }).isPresent();
    }

    private static boolean invalidFinalCombination(int type) {
        return type == 63 || type == 65 || type == 68 || type == 94;
    }

    private static boolean invalidFinalAnnotation(int type, DetailAST ast) {
        if (type != 159) {
            return false;
        }
        String annotationName = ast.findFirstToken(58).getText();
        return "JsonProperty".equals(annotationName) || "JsonAlias".equals(annotationName) || "JacksonXmlProperty".equals(annotationName);
    }

    public static boolean isPublicOrProtected(DetailAST astWithModifiers) {
        AccessModifierOption access = CheckUtil.getAccessModifierFromModifiersToken((DetailAST)astWithModifiers);
        return access == AccessModifierOption.PUBLIC || access == AccessModifierOption.PROTECTED;
    }

    private SdkCheckUtils() {
    }
}

